/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationGrant;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.GrantType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.OAuth2Error;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.Secret;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;

@Immutable
public class ResourceOwnerPasswordCredentialsGrant
extends AuthorizationGrant {
    public static final GrantType GRANT_TYPE = GrantType.PASSWORD;
    private final String username;
    private final Secret password;

    public ResourceOwnerPasswordCredentialsGrant(String string, Secret secret) {
        super(GRANT_TYPE);
        if (string == null) {
            throw new IllegalArgumentException("The username must not be null");
        }
        this.username = string;
        if (secret == null) {
            throw new IllegalArgumentException("The password must not be null");
        }
        this.password = secret;
    }

    public String getUsername() {
        return this.username;
    }

    public Secret getPassword() {
        return this.password;
    }

    @Override
    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>();
        linkedHashMap.put("grant_type", Collections.singletonList(GRANT_TYPE.getValue()));
        linkedHashMap.put("username", Collections.singletonList(this.username));
        linkedHashMap.put("password", Collections.singletonList(this.password.getValue()));
        return linkedHashMap;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ResourceOwnerPasswordCredentialsGrant resourceOwnerPasswordCredentialsGrant = (ResourceOwnerPasswordCredentialsGrant)object;
        if (!this.username.equals(resourceOwnerPasswordCredentialsGrant.username)) {
            return false;
        }
        return this.password.equals(resourceOwnerPasswordCredentialsGrant.password);
    }

    public int hashCode() {
        int n2 = this.username.hashCode();
        n2 = 31 * n2 + this.password.hashCode();
        return n2;
    }

    public static ResourceOwnerPasswordCredentialsGrant parse(Map<String, List<String>> map) throws ParseException {
        GrantType.ensure(GRANT_TYPE, map);
        String string = MultivaluedMapUtils.getFirstValue(map, "username");
        if (string == null || string.trim().isEmpty()) {
            String string2 = "Missing or empty username parameter";
            throw new ParseException(string2, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string2));
        }
        String string3 = MultivaluedMapUtils.getFirstValue(map, "password");
        if (string3 == null || string3.trim().isEmpty()) {
            String string4 = "Missing or empty password parameter";
            throw new ParseException(string4, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string4));
        }
        Secret secret = new Secret(string3);
        return new ResourceOwnerPasswordCredentialsGrant(string, secret);
    }
}

