/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTClaimsSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWTParser;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AbstractRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.OAuth2Error;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ParseException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ResponseMode;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.ResponseType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.Scope;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.client.RedirectURIValidator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.dpop.JWKThumbprintConfirmation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.State;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.pkce.CodeChallenge;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.pkce.CodeChallengeMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.rar.AuthorizationDetail;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JSONArrayUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.JWTClaimsSetUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.MultivaluedMapUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.ResourceUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.StringUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URIUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.AuthenticationRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.Prompt;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.openid.connect.sdk.federation.trust.TrustChain;
import macromedia.jdbc.sqlserver.externals.net.jcip.annotations.Immutable;
import macromedia.jdbc.sqlserver.externals.net.minidev.json.JSONArray;

@Immutable
public class AuthorizationRequest
extends AbstractRequest {
    private static final Set<String> REGISTERED_PARAMETER_NAMES;
    private final ResponseType rt;
    private final ClientID clientID;
    private final URI redirectURI;
    private final Scope scope;
    private final State state;
    private final ResponseMode rm;
    private final CodeChallenge codeChallenge;
    private final CodeChallengeMethod codeChallengeMethod;
    private final List<AuthorizationDetail> authorizationDetails;
    private final List<URI> resources;
    private final boolean includeGrantedScopes;
    private final JWT requestObject;
    private final URI requestURI;
    protected final Prompt prompt;
    private final JWKThumbprintConfirmation dpopJKT;
    private final TrustChain trustChain;
    private final Map<String, List<String>> customParams;

    public AuthorizationRequest(URI uRI, ResponseType responseType, ClientID clientID) {
        this(uRI, responseType, null, clientID, null, null, null, null, null, null, false, null, null, null, null);
    }

    public AuthorizationRequest(URI uRI, ResponseType responseType, ResponseMode responseMode, ClientID clientID, URI uRI2, Scope scope, State state) {
        this(uRI, responseType, responseMode, clientID, uRI2, scope, state, null, null, null, false, null, null, null, null);
    }

    @Deprecated
    public AuthorizationRequest(URI uRI, ResponseType responseType, ResponseMode responseMode, ClientID clientID, URI uRI2, Scope scope, State state, CodeChallenge codeChallenge, CodeChallengeMethod codeChallengeMethod, List<URI> list, boolean bl2, JWT jWT, URI uRI3, Prompt prompt, Map<String, List<String>> map) {
        this(uRI, responseType, responseMode, clientID, uRI2, scope, state, codeChallenge, codeChallengeMethod, list, bl2, jWT, uRI3, prompt, null, map);
    }

    @Deprecated
    public AuthorizationRequest(URI uRI, ResponseType responseType, ResponseMode responseMode, ClientID clientID, URI uRI2, Scope scope, State state, CodeChallenge codeChallenge, CodeChallengeMethod codeChallengeMethod, List<URI> list, boolean bl2, JWT jWT, URI uRI3, Prompt prompt, JWKThumbprintConfirmation jWKThumbprintConfirmation, Map<String, List<String>> map) {
        this(uRI, responseType, responseMode, clientID, uRI2, scope, state, codeChallenge, codeChallengeMethod, list, bl2, jWT, uRI3, prompt, jWKThumbprintConfirmation, null, map);
    }

    @Deprecated
    public AuthorizationRequest(URI uRI, ResponseType responseType, ResponseMode responseMode, ClientID clientID, URI uRI2, Scope scope, State state, CodeChallenge codeChallenge, CodeChallengeMethod codeChallengeMethod, List<URI> list, boolean bl2, JWT jWT, URI uRI3, Prompt prompt, JWKThumbprintConfirmation jWKThumbprintConfirmation, TrustChain trustChain, Map<String, List<String>> map) {
        this(uRI, responseType, responseMode, clientID, uRI2, scope, state, codeChallenge, codeChallengeMethod, null, list, bl2, jWT, uRI3, prompt, jWKThumbprintConfirmation, trustChain, map);
    }

    public AuthorizationRequest(URI uRI, ResponseType responseType, ResponseMode responseMode, ClientID clientID, URI uRI2, Scope scope, State state, CodeChallenge codeChallenge, CodeChallengeMethod codeChallengeMethod, List<AuthorizationDetail> list, List<URI> list2, boolean bl2, JWT jWT, URI uRI3, Prompt prompt, JWKThumbprintConfirmation jWKThumbprintConfirmation, TrustChain trustChain, Map<String, List<String>> map) {
        super(uRI);
        if (responseType == null && jWT == null && uRI3 == null) {
            throw new IllegalArgumentException("The response type must not be null");
        }
        this.rt = responseType;
        this.rm = responseMode;
        if (clientID == null) {
            throw new IllegalArgumentException("The client ID must not be null");
        }
        this.clientID = clientID;
        RedirectURIValidator.ensureLegal(uRI2);
        this.redirectURI = uRI2;
        this.scope = scope;
        this.state = state;
        this.codeChallenge = codeChallenge;
        this.codeChallengeMethod = codeChallengeMethod;
        this.authorizationDetails = list;
        this.resources = ResourceUtils.ensureLegalResourceURIs(list2);
        this.includeGrantedScopes = bl2;
        if (jWT != null && uRI3 != null) {
            throw new IllegalArgumentException("Either a request object or a request URI must be specified, but not both");
        }
        this.requestObject = jWT;
        this.requestURI = uRI3;
        if (jWT instanceof SignedJWT) {
            JWTClaimsSet jWTClaimsSet;
            try {
                jWTClaimsSet = jWT.getJWTClaimsSet();
            }
            catch (java.text.ParseException parseException) {
                throw new IllegalArgumentException("Illegal request parameter: " + parseException.getMessage(), parseException);
            }
            if (clientID.getValue().equals(jWTClaimsSet.getSubject())) {
                throw new IllegalArgumentException("Illegal request parameter: The JWT sub (subject) claim must not equal the client_id");
            }
        }
        this.prompt = prompt;
        this.dpopJKT = jWKThumbprintConfirmation;
        this.trustChain = trustChain;
        this.customParams = MapUtils.isNotEmpty(map) ? Collections.unmodifiableMap(map) : Collections.emptyMap();
    }

    public static Set<String> getRegisteredParameterNames() {
        return REGISTERED_PARAMETER_NAMES;
    }

    public ResponseType getResponseType() {
        return this.rt;
    }

    public ResponseMode getResponseMode() {
        return this.rm;
    }

    public ResponseMode impliedResponseMode() {
        return ResponseMode.resolve(this.rm, this.rt);
    }

    public ClientID getClientID() {
        return this.clientID;
    }

    public URI getRedirectionURI() {
        return this.redirectURI;
    }

    public Scope getScope() {
        return this.scope;
    }

    public State getState() {
        return this.state;
    }

    public CodeChallenge getCodeChallenge() {
        return this.codeChallenge;
    }

    public CodeChallengeMethod getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    public List<AuthorizationDetail> getAuthorizationDetails() {
        return this.authorizationDetails;
    }

    public List<URI> getResources() {
        return this.resources;
    }

    public boolean includeGrantedScopes() {
        return this.includeGrantedScopes;
    }

    public JWT getRequestObject() {
        return this.requestObject;
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    public boolean specifiesRequestObject() {
        return this.requestObject != null || this.requestURI != null;
    }

    public Prompt getPrompt() {
        return this.prompt;
    }

    public JWKThumbprintConfirmation getDPoPJWKThumbprintConfirmation() {
        return this.dpopJKT;
    }

    public TrustChain getTrustChain() {
        return this.trustChain;
    }

    public Map<String, List<String>> getCustomParameters() {
        return this.customParams;
    }

    public List<String> getCustomParameter(String string) {
        return this.customParams.get(string);
    }

    public Map<String, List<String>> toParameters() {
        LinkedHashMap<String, List<String>> linkedHashMap = new LinkedHashMap<String, List<String>>(this.customParams);
        linkedHashMap.put("client_id", Collections.singletonList(this.getClientID().getValue()));
        if (this.getResponseType() != null) {
            linkedHashMap.put("response_type", Collections.singletonList(this.getResponseType().toString()));
        }
        if (this.getResponseMode() != null) {
            linkedHashMap.put("response_mode", Collections.singletonList(this.getResponseMode().getValue()));
        }
        if (this.getRedirectionURI() != null) {
            linkedHashMap.put("redirect_uri", Collections.singletonList(this.getRedirectionURI().toString()));
        }
        if (this.getScope() != null) {
            linkedHashMap.put("scope", Collections.singletonList(this.getScope().toString()));
        }
        if (this.getState() != null) {
            linkedHashMap.put("state", Collections.singletonList(this.getState().getValue()));
        }
        if (this.getCodeChallenge() != null) {
            linkedHashMap.put("code_challenge", Collections.singletonList(this.getCodeChallenge().getValue()));
            if (this.getCodeChallengeMethod() != null) {
                linkedHashMap.put("code_challenge_method", Collections.singletonList(this.getCodeChallengeMethod().getValue()));
            }
        }
        if (this.getAuthorizationDetails() != null) {
            linkedHashMap.put("authorization_details", Collections.singletonList(AuthorizationDetail.toJSONString(this.getAuthorizationDetails())));
        }
        if (this.includeGrantedScopes()) {
            linkedHashMap.put("include_granted_scopes", Collections.singletonList("true"));
        }
        if (this.getResources() != null) {
            linkedHashMap.put("resource", URIUtils.toStringList(this.getResources()));
        }
        if (this.getRequestObject() != null) {
            try {
                linkedHashMap.put("request", Collections.singletonList(this.getRequestObject().serialize()));
            }
            catch (IllegalStateException illegalStateException) {
                throw new SerializeException("Couldn't serialize request object to JWT: " + illegalStateException.getMessage(), illegalStateException);
            }
        }
        if (this.getRequestURI() != null) {
            linkedHashMap.put("request_uri", Collections.singletonList(this.getRequestURI().toString()));
        }
        if (this.getPrompt() != null) {
            linkedHashMap.put("prompt", Collections.singletonList(this.getPrompt().toString()));
        }
        if (this.getDPoPJWKThumbprintConfirmation() != null) {
            linkedHashMap.put("dpop_jkt", Collections.singletonList(this.getDPoPJWKThumbprintConfirmation().getValue().toString()));
        }
        if (this.getTrustChain() != null) {
            JSONArray jSONArray = new JSONArray();
            jSONArray.addAll(this.getTrustChain().toSerializedJWTs());
            linkedHashMap.put("trust_chain", Collections.singletonList(jSONArray.toJSONString()));
        }
        return linkedHashMap;
    }

    public JWTClaimsSet toJWTClaimsSet() {
        if (this.specifiesRequestObject()) {
            throw new IllegalStateException("Cannot create nested JWT secured authorization request");
        }
        Map<String, List<String>> map = this.toParameters();
        JWTClaimsSet jWTClaimsSet = JWTClaimsSetUtils.toJWTClaimsSet(map);
        if (map.containsKey("trust_chain")) {
            jWTClaimsSet = new JWTClaimsSet.Builder(jWTClaimsSet).claim("trust_chain", this.getTrustChain().toSerializedJWTs()).build();
        }
        return jWTClaimsSet;
    }

    public String toQueryString() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        if (this.getEndpointURI() != null) {
            hashMap.putAll(URLUtils.parseParameters(this.getEndpointURI().getQuery()));
        }
        hashMap.putAll(this.toParameters());
        return URLUtils.serializeParameters(hashMap);
    }

    public URI toURI() {
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The authorization endpoint URI is not specified");
        }
        StringBuilder stringBuilder = new StringBuilder(URIUtils.stripQueryString(this.getEndpointURI()).toString());
        stringBuilder.append('?');
        stringBuilder.append(this.toQueryString());
        try {
            return new URI(stringBuilder.toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new SerializeException("Couldn't append query string: " + uRISyntaxException.getMessage(), uRISyntaxException);
        }
    }

    public HTTPRequest toHTTPRequest(HTTPRequest.Method method) {
        HTTPRequest hTTPRequest;
        if (this.getEndpointURI() == null) {
            throw new SerializeException("The endpoint URI is not specified");
        }
        if (method.equals((Object)HTTPRequest.Method.GET)) {
            hTTPRequest = new HTTPRequest(HTTPRequest.Method.GET, this.getEndpointURI());
        } else if (method.equals((Object)HTTPRequest.Method.POST)) {
            hTTPRequest = new HTTPRequest(HTTPRequest.Method.POST, this.getEndpointURI());
        } else {
            throw new IllegalArgumentException("The HTTP request method must be GET or POST");
        }
        hTTPRequest.appendQueryParameters(this.toParameters());
        return hTTPRequest;
    }

    @Override
    public HTTPRequest toHTTPRequest() {
        return this.toHTTPRequest(HTTPRequest.Method.GET);
    }

    public static AuthorizationRequest parse(Map<String, List<String>> map) throws ParseException {
        return AuthorizationRequest.parse(null, map);
    }

    public static AuthorizationRequest parse(URI uRI, Map<String, List<String>> map) throws ParseException {
        Cloneable cloneable;
        Prompt prompt;
        List<URI> list;
        Object object;
        Set<String> set = MultivaluedMapUtils.getKeysWithMoreThanOneValue(map, Collections.singleton("resource"));
        if (!set.isEmpty()) {
            String string = "Parameter(s) present more than once: " + set;
            throw new ParseException(string, OAuth2Error.INVALID_REQUEST.setDescription(string));
        }
        URI uRI2 = null;
        State state = State.parse(MultivaluedMapUtils.getFirstValue(map, "state"));
        ResponseMode responseMode = null;
        ResponseType responseType = null;
        String string = MultivaluedMapUtils.getFirstValue(map, "response_mode");
        if (StringUtils.isNotBlank(string)) {
            responseMode = new ResponseMode(string);
        }
        if (StringUtils.isBlank(string = MultivaluedMapUtils.getFirstValue(map, "client_id"))) {
            String string2 = "Missing client_id parameter";
            throw new ParseException(string2, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string2));
        }
        ClientID clientID = new ClientID(string);
        string = MultivaluedMapUtils.getFirstValue(map, "redirect_uri");
        if (StringUtils.isNotBlank(string)) {
            try {
                uRI2 = new URI(string);
                RedirectURIValidator.ensureLegal(uRI2);
            }
            catch (IllegalArgumentException | URISyntaxException exception) {
                String string3 = "Invalid redirect_uri parameter: " + exception.getMessage();
                throw new ParseException(string3, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string3));
            }
        }
        if (StringUtils.isNotBlank(string = MultivaluedMapUtils.getFirstValue(map, "response_type"))) {
            try {
                responseType = ResponseType.parse(string);
            }
            catch (ParseException parseException) {
                String string4 = "Invalid response_type parameter";
                throw new ParseException(string4, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string4), clientID, uRI2, responseMode, state, parseException);
            }
        }
        string = MultivaluedMapUtils.getFirstValue(map, "request_uri");
        URI uRI3 = null;
        if (StringUtils.isNotBlank(string)) {
            try {
                uRI3 = new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                String string5 = "Invalid request_uri parameter: " + uRISyntaxException.getMessage();
                throw new ParseException(string5, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string5), clientID, uRI2, ResponseMode.resolve(responseMode, responseType), state, uRISyntaxException);
            }
        }
        string = MultivaluedMapUtils.getFirstValue(map, "request");
        JWT jWT = null;
        if (StringUtils.isNotBlank(string)) {
            if (uRI3 != null) {
                String string6 = "Invalid request: Found mutually exclusive request and request_uri parameters";
                throw new ParseException(string6, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string6), clientID, uRI2, ResponseMode.resolve(responseMode, responseType), state, null);
            }
            try {
                jWT = JWTParser.parse(string);
                if (jWT instanceof SignedJWT) {
                    object = jWT.getJWTClaimsSet();
                    if (clientID.getValue().equals(((JWTClaimsSet)object).getSubject())) {
                        throw new java.text.ParseException("The JWT sub (subject) claim must not equal the client_id", 0);
                    }
                }
            }
            catch (java.text.ParseException parseException) {
                String string7 = "Invalid request parameter: " + parseException.getMessage();
                throw new ParseException(string7, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string7), clientID, uRI2, ResponseMode.resolve(responseMode, responseType), state, parseException);
            }
        }
        if (responseType == null && jWT == null && uRI3 == null) {
            object = "Missing response_type parameter";
            throw new ParseException((String)object, OAuth2Error.INVALID_REQUEST.appendDescription(": " + (String)object), clientID, uRI2, ResponseMode.resolve(responseMode, null), state, null);
        }
        string = MultivaluedMapUtils.getFirstValue(map, "scope");
        object = null;
        if (StringUtils.isNotBlank(string)) {
            object = Scope.parse(string);
        }
        CodeChallenge codeChallenge = null;
        CodeChallengeMethod codeChallengeMethod = null;
        string = MultivaluedMapUtils.getFirstValue(map, "code_challenge");
        if (StringUtils.isNotBlank(string)) {
            codeChallenge = CodeChallenge.parse(string);
        }
        if (codeChallenge != null && StringUtils.isNotBlank(string = MultivaluedMapUtils.getFirstValue(map, "code_challenge_method"))) {
            codeChallengeMethod = CodeChallengeMethod.parse(string);
        }
        List<AuthorizationDetail> list2 = null;
        string = MultivaluedMapUtils.getFirstValue(map, "authorization_details");
        if (StringUtils.isNotBlank(string)) {
            list2 = AuthorizationDetail.parseList(string);
        }
        try {
            list = ResourceUtils.parseResourceURIs(map.get("resource"));
        }
        catch (ParseException parseException) {
            throw new ParseException(parseException.getMessage(), OAuth2Error.INVALID_TARGET.setDescription(parseException.getMessage()), clientID, uRI2, ResponseMode.resolve(responseMode, responseType), state, parseException);
        }
        boolean bl2 = false;
        string = MultivaluedMapUtils.getFirstValue(map, "include_granted_scopes");
        if ("true".equals(string)) {
            bl2 = true;
        }
        try {
            prompt = Prompt.parse(MultivaluedMapUtils.getFirstValue(map, "prompt"));
        }
        catch (ParseException parseException) {
            String string8 = "Invalid prompt parameter: " + parseException.getMessage();
            throw new ParseException(string8, OAuth2Error.INVALID_REQUEST.appendDescription(": " + string8), clientID, uRI2, ResponseMode.resolve(responseMode, responseType), state, parseException);
        }
        JWKThumbprintConfirmation jWKThumbprintConfirmation = null;
        string = MultivaluedMapUtils.getFirstValue(map, "dpop_jkt");
        if (StringUtils.isNotBlank(string)) {
            jWKThumbprintConfirmation = new JWKThumbprintConfirmation(new Base64URL(string));
        }
        TrustChain trustChain = null;
        string = MultivaluedMapUtils.getFirstValue(map, "trust_chain");
        if (StringUtils.isNotBlank(string)) {
            cloneable = JSONArrayUtils.parse(string);
            trustChain = TrustChain.parseSerialized(JSONArrayUtils.toStringList(cloneable));
        }
        cloneable = null;
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            if (REGISTERED_PARAMETER_NAMES.contains(entry.getKey())) continue;
            if (cloneable == null) {
                cloneable = new HashMap();
            }
            cloneable.put(entry.getKey(), entry.getValue());
        }
        return new AuthorizationRequest(uRI, responseType, responseMode, clientID, uRI2, (Scope)object, state, codeChallenge, codeChallengeMethod, list2, list, bl2, jWT, uRI3, prompt, jWKThumbprintConfirmation, trustChain, (Map<String, List<String>>)((Object)cloneable));
    }

    public static AuthorizationRequest parse(String string) throws ParseException {
        return AuthorizationRequest.parse(null, URLUtils.parseParameters(string));
    }

    public static AuthorizationRequest parse(URI uRI, String string) throws ParseException {
        return AuthorizationRequest.parse(uRI, URLUtils.parseParameters(string));
    }

    public static AuthorizationRequest parse(URI uRI) throws ParseException {
        return AuthorizationRequest.parse(URIUtils.getBaseURI(uRI), URLUtils.parseParameters(uRI.getRawQuery()));
    }

    public static AuthorizationRequest parse(HTTPRequest hTTPRequest) throws ParseException {
        String string = hTTPRequest.getQuery();
        if (string == null) {
            throw new ParseException("Missing URI query string");
        }
        return AuthorizationRequest.parse(URIUtils.getBaseURI(hTTPRequest.getURI()), string);
    }

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("response_type");
        hashSet.add("client_id");
        hashSet.add("redirect_uri");
        hashSet.add("scope");
        hashSet.add("state");
        hashSet.add("response_mode");
        hashSet.add("code_challenge");
        hashSet.add("code_challenge_method");
        hashSet.add("authorization_details");
        hashSet.add("resource");
        hashSet.add("include_granted_scopes");
        hashSet.add("request_uri");
        hashSet.add("request");
        hashSet.add("prompt");
        hashSet.add("dpop_jkt");
        hashSet.add("trust_chain");
        REGISTERED_PARAMETER_NAMES = Collections.unmodifiableSet(hashSet);
    }

    public static class Builder {
        private URI uri;
        private ResponseType rt;
        private final ClientID clientID;
        private URI redirectURI;
        private Scope scope;
        private State state;
        private ResponseMode rm;
        private CodeChallenge codeChallenge;
        private CodeChallengeMethod codeChallengeMethod;
        private List<AuthorizationDetail> authorizationDetails;
        private List<URI> resources;
        private boolean includeGrantedScopes;
        private JWT requestObject;
        private URI requestURI;
        private Prompt prompt;
        private JWKThumbprintConfirmation dpopJKT;
        private TrustChain trustChain;
        private final Map<String, List<String>> customParams = new HashMap<String, List<String>>();

        public Builder(ResponseType responseType, ClientID clientID) {
            if (responseType == null) {
                throw new IllegalArgumentException("The response type must not be null");
            }
            this.rt = responseType;
            if (clientID == null) {
                throw new IllegalArgumentException("The client ID must not be null");
            }
            this.clientID = clientID;
        }

        public Builder(JWT jWT, ClientID clientID) {
            if (jWT == null) {
                throw new IllegalArgumentException("The request object must not be null");
            }
            this.requestObject = jWT;
            if (clientID == null) {
                throw new IllegalArgumentException("The client ID must not be null");
            }
            this.clientID = clientID;
        }

        public Builder(URI uRI, ClientID clientID) {
            if (uRI == null) {
                throw new IllegalArgumentException("The request URI must not be null");
            }
            this.requestURI = uRI;
            if (clientID == null) {
                throw new IllegalArgumentException("The client ID must not be null");
            }
            this.clientID = clientID;
        }

        public Builder(AuthorizationRequest authorizationRequest) {
            this.uri = authorizationRequest.getEndpointURI();
            this.scope = authorizationRequest.getScope();
            this.rt = authorizationRequest.getResponseType();
            this.clientID = authorizationRequest.getClientID();
            this.redirectURI = authorizationRequest.getRedirectionURI();
            this.state = authorizationRequest.getState();
            this.rm = authorizationRequest.getResponseMode();
            this.codeChallenge = authorizationRequest.getCodeChallenge();
            this.codeChallengeMethod = authorizationRequest.getCodeChallengeMethod();
            this.authorizationDetails = authorizationRequest.getAuthorizationDetails();
            this.resources = authorizationRequest.getResources();
            this.includeGrantedScopes = authorizationRequest.includeGrantedScopes();
            this.requestObject = authorizationRequest.getRequestObject();
            this.requestURI = authorizationRequest.getRequestURI();
            this.prompt = authorizationRequest.getPrompt();
            this.dpopJKT = authorizationRequest.getDPoPJWKThumbprintConfirmation();
            this.trustChain = authorizationRequest.getTrustChain();
            if (authorizationRequest instanceof AuthenticationRequest) {
                AuthenticationRequest authenticationRequest = (AuthenticationRequest)authorizationRequest;
                for (Map.Entry<String, List<String>> entry : authenticationRequest.toParameters().entrySet()) {
                    if (REGISTERED_PARAMETER_NAMES.contains(entry.getKey())) continue;
                    this.customParams.put(entry.getKey(), entry.getValue());
                }
            } else {
                this.customParams.putAll(authorizationRequest.getCustomParameters());
            }
        }

        public Builder responseType(ResponseType responseType) {
            if (responseType == null) {
                throw new IllegalArgumentException("The response type must not be null");
            }
            this.rt = responseType;
            return this;
        }

        public Builder redirectionURI(URI uRI) {
            this.redirectURI = uRI;
            return this;
        }

        public Builder scope(Scope scope) {
            this.scope = scope;
            return this;
        }

        public Builder state(State state) {
            this.state = state;
            return this;
        }

        public Builder responseMode(ResponseMode responseMode) {
            this.rm = responseMode;
            return this;
        }

        @Deprecated
        public Builder codeChallenge(CodeChallenge codeChallenge, CodeChallengeMethod codeChallengeMethod) {
            this.codeChallenge = codeChallenge;
            this.codeChallengeMethod = codeChallengeMethod;
            return this;
        }

        public Builder codeChallenge(CodeVerifier codeVerifier, CodeChallengeMethod codeChallengeMethod) {
            if (codeVerifier != null) {
                CodeChallengeMethod codeChallengeMethod2 = codeChallengeMethod != null ? codeChallengeMethod : CodeChallengeMethod.getDefault();
                this.codeChallenge = CodeChallenge.compute(codeChallengeMethod2, codeVerifier);
                this.codeChallengeMethod = codeChallengeMethod2;
            } else {
                this.codeChallenge = null;
                this.codeChallengeMethod = null;
            }
            return this;
        }

        public Builder authorizationDetails(List<AuthorizationDetail> list) {
            this.authorizationDetails = list;
            return this;
        }

        public Builder resource(URI uRI) {
            this.resources = uRI != null ? Collections.singletonList(uRI) : null;
            return this;
        }

        public Builder resources(URI ... uRIArray) {
            this.resources = uRIArray != null ? Arrays.asList(uRIArray) : null;
            return this;
        }

        public Builder includeGrantedScopes(boolean bl2) {
            this.includeGrantedScopes = bl2;
            return this;
        }

        public Builder requestObject(JWT jWT) {
            this.requestObject = jWT;
            return this;
        }

        public Builder requestURI(URI uRI) {
            this.requestURI = uRI;
            return this;
        }

        public Builder prompt(Prompt prompt) {
            this.prompt = prompt;
            return this;
        }

        public Builder prompt(Prompt.Type ... typeArray) {
            if (typeArray.length == 1 && typeArray[0] == null) {
                return this.prompt((Prompt)null);
            }
            return this.prompt(new Prompt(typeArray));
        }

        public Builder dPoPJWKThumbprintConfirmation(JWKThumbprintConfirmation jWKThumbprintConfirmation) {
            this.dpopJKT = jWKThumbprintConfirmation;
            return this;
        }

        public Builder trustChain(TrustChain trustChain) {
            this.trustChain = trustChain;
            return this;
        }

        public Builder customParameter(String string, String ... stringArray) {
            if (stringArray == null || stringArray.length == 0) {
                this.customParams.remove(string);
            } else {
                this.customParams.put(string, Arrays.asList(stringArray));
            }
            return this;
        }

        public Builder endpointURI(URI uRI) {
            this.uri = uRI;
            return this;
        }

        public AuthorizationRequest build() {
            try {
                return new AuthorizationRequest(this.uri, this.rt, this.rm, this.clientID, this.redirectURI, this.scope, this.state, this.codeChallenge, this.codeChallengeMethod, this.authorizationDetails, this.resources, this.includeGrantedScopes, this.requestObject, this.requestURI, this.prompt, this.dpopJKT, this.trustChain, this.customParams);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }
    }
}

