/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag;

import java.util.LinkedList;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.LangTagException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.langtag.ReadOnlyLangTag;

public class LangTag
implements ReadOnlyLangTag {
    private String primaryLanguage;
    private String[] languageSubtags;
    private String script = null;
    private String region = null;
    private String[] variants = null;
    private String[] extensions = null;
    private String privateUse = null;

    private static void ensureMaxLength(String string) throws LangTagException {
        if (string.length() > 8 && string.charAt(1) != '-' && string.length() > 10) {
            throw new LangTagException("Invalid subtag syntax: Max character length exceeded");
        }
    }

    public LangTag(String string) throws LangTagException {
        this(string, new String[0]);
    }

    public LangTag(String string, String ... stringArray) throws LangTagException {
        if (string == null && (stringArray == null || stringArray.length == 0)) {
            throw new LangTagException("Either the primary language or the extended language subtags, or both must be defined");
        }
        this.setPrimaryLanguage(string);
        this.setExtendedLanguageSubtags(stringArray);
    }

    @Override
    public String getLanguage() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.primaryLanguage != null) {
            stringBuilder.append(this.primaryLanguage);
        }
        if (this.languageSubtags != null && this.languageSubtags.length > 0) {
            for (String string : this.languageSubtags) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('-');
                }
                stringBuilder.append(string);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public String getPrimaryLanguage() {
        return this.primaryLanguage;
    }

    private static boolean isPrimaryLanguage(String string) {
        return string.matches("[a-zA-Z]{2,3}");
    }

    private void setPrimaryLanguage(String string) throws LangTagException {
        if (string == null) {
            this.primaryLanguage = null;
            return;
        }
        LangTag.ensureMaxLength(string);
        if (!LangTag.isPrimaryLanguage(string)) {
            throw new LangTagException("Invalid primary language subtag: Must be a two or three-letter ISO 639 code");
        }
        this.primaryLanguage = string.toLowerCase();
    }

    @Override
    public String[] getExtendedLanguageSubtags() {
        return this.languageSubtags;
    }

    private static boolean isExtendedLanguageSubtag(String string) {
        return string.matches("[a-zA-Z]{3}");
    }

    private void setExtendedLanguageSubtags(String ... stringArray) throws LangTagException {
        if (stringArray == null || stringArray.length == 0) {
            this.languageSubtags = null;
            return;
        }
        this.languageSubtags = new String[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            LangTag.ensureMaxLength(stringArray[i2]);
            if (!LangTag.isExtendedLanguageSubtag(stringArray[i2])) {
                throw new LangTagException("Invalid extended language subtag: Must be a three-letter ISO 639-3 code");
            }
            this.languageSubtags[i2] = stringArray[i2].toLowerCase();
        }
    }

    @Override
    public String getScript() {
        return this.script;
    }

    private static boolean isScript(String string) {
        return string.matches("[a-zA-Z]{4}");
    }

    public void setScript(String string) throws LangTagException {
        if (string == null) {
            this.script = null;
            return;
        }
        LangTag.ensureMaxLength(string);
        if (!LangTag.isScript(string)) {
            throw new LangTagException("Invalid script subtag: Must be a four-letter ISO 15924 code");
        }
        this.script = string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    private static boolean isRegion(String string) {
        return string.matches("[a-zA-Z]{2}|\\d{3}");
    }

    public void setRegion(String string) throws LangTagException {
        if (string == null) {
            this.region = null;
            return;
        }
        LangTag.ensureMaxLength(string);
        if (!LangTag.isRegion(string)) {
            throw new LangTagException("Invalid region subtag: Must be a two-letter ISO 3166-1 code or a three-digit UN M.49 code");
        }
        this.region = string.toUpperCase();
    }

    @Override
    public String[] getVariants() {
        return this.variants;
    }

    private static boolean isVariant(String string) {
        return string.matches("[a-zA-Z][a-zA-Z0-9]{4,}|[0-9][a-zA-Z0-9]{3,}");
    }

    public void setVariants(String ... stringArray) throws LangTagException {
        if (stringArray == null || stringArray.length == 0) {
            this.variants = null;
            return;
        }
        this.variants = new String[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            LangTag.ensureMaxLength(stringArray[i2]);
            if (!LangTag.isVariant(stringArray[i2])) {
                throw new LangTagException("Invalid variant subtag");
            }
            this.variants[i2] = stringArray[i2].toLowerCase();
        }
    }

    @Override
    public String[] getExtensions() {
        return this.extensions;
    }

    private static boolean isExtensionSingleton(String string) {
        return string.matches("[0-9a-wA-Wy-zY-Z]");
    }

    private static boolean isExtension(String string) {
        return string.matches("[0-9a-wA-Wy-zY-Z]-[0-9a-zA-Z]+");
    }

    public void setExtensions(String ... stringArray) throws LangTagException {
        if (stringArray == null || stringArray.length == 0) {
            this.extensions = null;
            return;
        }
        this.extensions = new String[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            LangTag.ensureMaxLength(stringArray[i2]);
            if (!LangTag.isExtension(stringArray[i2])) {
                throw new LangTagException("Invalid extension subtag");
            }
            this.extensions[i2] = stringArray[i2].toLowerCase();
        }
    }

    @Override
    public String getPrivateUse() {
        return this.privateUse;
    }

    private static boolean isPrivateUse(String string) {
        return string.matches("x-[0-9a-zA-Z]+");
    }

    public void setPrivateUse(String string) throws LangTagException {
        if (string == null) {
            this.privateUse = null;
            return;
        }
        LangTag.ensureMaxLength(string);
        if (!LangTag.isPrivateUse(string)) {
            throw new LangTagException("Invalid private use subtag");
        }
        this.privateUse = string.toLowerCase();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getLanguage());
        if (this.script != null) {
            stringBuilder.append('-');
            stringBuilder.append(this.script);
        }
        if (this.region != null) {
            stringBuilder.append('-');
            stringBuilder.append(this.region);
        }
        if (this.variants != null) {
            for (String string : this.variants) {
                stringBuilder.append('-');
                stringBuilder.append(string);
            }
        }
        if (this.extensions != null) {
            for (String string : this.extensions) {
                stringBuilder.append('-');
                stringBuilder.append(string);
            }
        }
        if (this.privateUse != null) {
            stringBuilder.append('-');
            stringBuilder.append(this.privateUse);
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object object) {
        return object != null && object instanceof LangTag && this.toString().equals(object.toString());
    }

    public static LangTag parse(String string) throws LangTagException {
        if (string == null || string.trim().isEmpty()) {
            return null;
        }
        String[] stringArray = string.split("-");
        int n2 = 0;
        String string2 = null;
        LinkedList<String> linkedList = new LinkedList<String>();
        if (LangTag.isPrimaryLanguage(stringArray[0])) {
            string2 = stringArray[n2++];
        }
        while (n2 < stringArray.length && LangTag.isExtendedLanguageSubtag(stringArray[n2])) {
            linkedList.add(stringArray[n2++]);
        }
        LangTag langTag = new LangTag(string2, linkedList.toArray(new String[0]));
        if (n2 < stringArray.length && LangTag.isScript(stringArray[n2])) {
            langTag.setScript(stringArray[n2++]);
        }
        if (n2 < stringArray.length && LangTag.isRegion(stringArray[n2])) {
            langTag.setRegion(stringArray[n2++]);
        }
        LinkedList<String> linkedList2 = new LinkedList<String>();
        while (n2 < stringArray.length && LangTag.isVariant(stringArray[n2])) {
            linkedList2.add(stringArray[n2++]);
        }
        if (!linkedList2.isEmpty()) {
            langTag.setVariants(linkedList2.toArray(new String[0]));
        }
        LinkedList<String> linkedList3 = new LinkedList<String>();
        while (n2 < stringArray.length && LangTag.isExtensionSingleton(stringArray[n2])) {
            String string3 = stringArray[n2++];
            if (n2 == stringArray.length) {
                throw new LangTagException("Invalid extension subtag");
            }
            linkedList3.add(string3 + "-" + stringArray[n2++]);
        }
        if (!linkedList3.isEmpty()) {
            langTag.setExtensions(linkedList3.toArray(new String[0]));
        }
        if (n2 < stringArray.length && stringArray[n2].equals("x")) {
            if (++n2 == stringArray.length) {
                throw new LangTagException("Invalid private use subtag");
            }
            langTag.setPrivateUse("x-" + stringArray[n2++]);
        }
        if (n2 < stringArray.length) {
            throw new LangTagException("Invalid language tag: Unexpected subtag");
        }
        return langTag;
    }
}

