/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt;

import java.text.ParseException;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Algorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Header;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONObjectUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.EncryptedJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.JWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.PlainJWT;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jwt.SignedJWT;

public final class JWTParser {
    public static JWT parse(String string) throws ParseException {
        Map<String, Object> map;
        int n2 = string.indexOf(".");
        if (n2 == -1) {
            throw new ParseException("Invalid JWT serialization: Missing dot delimiter(s)", 0);
        }
        Base64URL base64URL = new Base64URL(string.substring(0, n2));
        try {
            map = JSONObjectUtils.parse(base64URL.decodeToString());
        }
        catch (ParseException parseException) {
            throw new ParseException("Invalid unsecured/JWS/JWE header: " + parseException.getMessage(), 0);
        }
        Algorithm algorithm = Header.parseAlgorithm(map);
        if (algorithm.equals(Algorithm.NONE)) {
            return PlainJWT.parse(string);
        }
        if (algorithm instanceof JWSAlgorithm) {
            return SignedJWT.parse(string);
        }
        if (algorithm instanceof JWEAlgorithm) {
            return EncryptedJWT.parse(string);
        }
        throw new AssertionError((Object)("Unexpected algorithm type: " + algorithm));
    }

    private JWTParser() {
    }
}

