/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.health;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.Immutable;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.events.Event;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.health.HealthStatus;

@Immutable
public class HealthReport<S, C extends SecurityContext>
implements Event<S, C> {
    private final S source;
    private final HealthStatus status;
    private final Exception exception;
    private final long timestamp;
    private final C context;

    public HealthReport(S s2, HealthStatus healthStatus, long l2, C c2) {
        this(s2, healthStatus, null, l2, c2);
    }

    public HealthReport(S s2, HealthStatus healthStatus, Exception exception, long l2, C c2) {
        Objects.requireNonNull(s2);
        this.source = s2;
        Objects.requireNonNull(healthStatus);
        this.status = healthStatus;
        if (exception != null && HealthStatus.HEALTHY.equals((Object)healthStatus)) {
            throw new IllegalArgumentException("Exception not accepted for a healthy status");
        }
        this.exception = exception;
        this.timestamp = l2;
        this.context = c2;
    }

    @Override
    public S getSource() {
        return this.source;
    }

    @Override
    public C getContext() {
        return this.context;
    }

    public HealthStatus getHealthStatus() {
        return this.status;
    }

    public Exception getException() {
        return this.exception;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("HealthReport{");
        stringBuilder.append("source=").append(this.source);
        stringBuilder.append(", status=").append((Object)this.status);
        stringBuilder.append(", exception=").append(this.exception);
        stringBuilder.append(", timestamp=").append(this.timestamp);
        stringBuilder.append(", context=").append(this.context);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

