/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.StandardCharset;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.X509CertUtils;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.openssl.PEMParser;

public class X509CertChainUtils {
    public static List<Base64> toBase64List(List<Object> list) throws ParseException {
        if (list == null) {
            return null;
        }
        LinkedList<Base64> linkedList = new LinkedList<Base64>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Object object = list.get(i2);
            if (object == null) {
                throw new ParseException("The X.509 certificate at position " + i2 + " must not be null", 0);
            }
            if (!(object instanceof String)) {
                throw new ParseException("The X.509 certificate at position " + i2 + " must be encoded as a Base64 string", 0);
            }
            linkedList.add(new Base64((String)object));
        }
        return linkedList;
    }

    public static List<X509Certificate> parse(List<Base64> list) throws ParseException {
        if (list == null) {
            return null;
        }
        LinkedList<X509Certificate> linkedList = new LinkedList<X509Certificate>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            if (list.get(i2) == null) continue;
            X509Certificate x509Certificate = X509CertUtils.parse(list.get(i2).decode());
            if (x509Certificate == null) {
                throw new ParseException("Invalid X.509 certificate at position " + i2, 0);
            }
            linkedList.add(x509Certificate);
        }
        return linkedList;
    }

    public static List<X509Certificate> parse(File file) throws IOException, CertificateException {
        String string = new String(Files.readAllBytes(file.toPath()), StandardCharset.UTF_8);
        return X509CertChainUtils.parse(string);
    }

    public static List<X509Certificate> parse(String string) throws IOException, CertificateException {
        Object object;
        StringReader stringReader = new StringReader(string);
        PEMParser pEMParser = new PEMParser((Reader)stringReader);
        LinkedList<X509Certificate> linkedList = new LinkedList<X509Certificate>();
        do {
            if (!((object = pEMParser.readObject()) instanceof X509CertificateHolder)) continue;
            X509CertificateHolder x509CertificateHolder = (X509CertificateHolder)object;
            byte[] byArray = x509CertificateHolder.getEncoded();
            linkedList.add(X509CertUtils.parseWithException(byArray));
        } while (object != null);
        return linkedList;
    }

    public static List<UUID> store(KeyStore keyStore, List<X509Certificate> list) throws KeyStoreException {
        LinkedList<UUID> linkedList = new LinkedList<UUID>();
        for (X509Certificate x509Certificate : list) {
            UUID uUID = UUID.randomUUID();
            keyStore.setCertificateEntry(uUID.toString(), x509Certificate);
            linkedList.add(uUID);
        }
        return linkedList;
    }

    private X509CertChainUtils() {
    }
}

