/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.AbstractRestrictedResourceRetriever;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.BoundedInputStream;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.IOUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Resource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.RestrictedResourceRetriever;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.StandardCharset;

@ThreadSafe
public class DefaultResourceRetriever
extends AbstractRestrictedResourceRetriever
implements RestrictedResourceRetriever {
    private boolean disconnectAfterUse;
    private final SSLSocketFactory sslSocketFactory;
    private Proxy proxy;

    public DefaultResourceRetriever() {
        this(0, 0);
    }

    public DefaultResourceRetriever(int n2, int n3) {
        this(n2, n3, 0);
    }

    public DefaultResourceRetriever(int n2, int n3, int n4) {
        this(n2, n3, n4, true);
    }

    public DefaultResourceRetriever(int n2, int n3, int n4, boolean bl2) {
        this(n2, n3, n4, bl2, null);
    }

    public DefaultResourceRetriever(int n2, int n3, int n4, boolean bl2, SSLSocketFactory sSLSocketFactory) {
        super(n2, n3, n4);
        this.disconnectAfterUse = bl2;
        this.sslSocketFactory = sSLSocketFactory;
    }

    public boolean disconnectsAfterUse() {
        return this.disconnectAfterUse;
    }

    public void setDisconnectsAfterUse(boolean bl2) {
        this.disconnectAfterUse = bl2;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    @Override
    public Resource retrieveResource(URL uRL) throws IOException {
        URLConnection uRLConnection = null;
        try {
            String string;
            uRLConnection = "file".equals(uRL.getProtocol()) ? this.openFileConnection(uRL) : this.openConnection(uRL);
            uRLConnection.setConnectTimeout(this.getConnectTimeout());
            uRLConnection.setReadTimeout(this.getReadTimeout());
            if (uRLConnection instanceof HttpsURLConnection && this.sslSocketFactory != null) {
                ((HttpsURLConnection)uRLConnection).setSSLSocketFactory(this.sslSocketFactory);
            }
            if (uRLConnection instanceof HttpURLConnection && this.getHeaders() != null && !this.getHeaders().isEmpty()) {
                for (Map.Entry object2 : this.getHeaders().entrySet()) {
                    for (String string2 : (List)object2.getValue()) {
                        uRLConnection.addRequestProperty((String)object2.getKey(), string2);
                    }
                }
            }
            try (InputStream inputStream = this.getInputStream(uRLConnection, this.getSizeLimit());){
                string = IOUtils.readInputStreamToString(inputStream, StandardCharset.UTF_8);
            }
            if (uRLConnection instanceof HttpURLConnection) {
                String string2;
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                int n2 = httpURLConnection.getResponseCode();
                string2 = httpURLConnection.getResponseMessage();
                if (n2 > 299 || n2 < 200) {
                    throw new IOException("HTTP " + n2 + ": " + string2);
                }
            }
            String string3 = uRLConnection instanceof HttpURLConnection ? uRLConnection.getContentType() : null;
            Resource resource = new Resource(string, string3);
            return resource;
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw exception;
            }
            throw new IOException("Couldn't open URL connection: " + exception.getMessage(), exception);
        }
        finally {
            if (this.disconnectAfterUse && uRLConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)uRLConnection).disconnect();
            }
        }
    }

    @Deprecated
    protected HttpURLConnection openConnection(URL uRL) throws IOException {
        return this.openHTTPConnection(uRL);
    }

    protected HttpURLConnection openHTTPConnection(URL uRL) throws IOException {
        if (this.proxy != null) {
            return (HttpURLConnection)uRL.openConnection(this.proxy);
        }
        return (HttpURLConnection)uRL.openConnection();
    }

    protected URLConnection openFileConnection(URL uRL) throws IOException {
        return uRL.openConnection();
    }

    private InputStream getInputStream(URLConnection uRLConnection, int n2) throws IOException {
        InputStream inputStream = uRLConnection.getInputStream();
        return n2 > 0 ? new BoundedInputStream(inputStream, this.getSizeLimit()) : inputStream;
    }
}

