/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util;

import java.io.IOException;
import java.io.InputStream;

public class BoundedInputStream
extends InputStream {
    private final InputStream in;
    private final long max;
    private long pos = 0L;
    private long mark = -1L;
    private boolean propagateClose = true;

    public BoundedInputStream(InputStream inputStream, long l2) {
        this.max = l2;
        this.in = inputStream;
    }

    public BoundedInputStream(InputStream inputStream) {
        this(inputStream, -1L);
    }

    public long getLimitBytes() {
        return this.max;
    }

    @Override
    public int read() throws IOException {
        if (this.max >= 0L && this.pos >= this.max) {
            throw new IOException("Exceeded configured input limit of " + this.max + " bytes");
        }
        int n2 = this.in.read();
        ++this.pos;
        return n2;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n2, int n3) throws IOException {
        if (this.max >= 0L && this.pos >= this.max) {
            throw new IOException("Exceeded configured input limit of " + this.max + " bytes");
        }
        int n4 = this.in.read(byArray, n2, n3);
        if (n4 == -1) {
            return -1;
        }
        this.pos += (long)n4;
        if (this.max >= 0L && this.pos >= this.max) {
            throw new IOException("Exceeded configured input limit of " + this.max + " bytes");
        }
        return n4;
    }

    @Override
    public long skip(long l2) throws IOException {
        long l3 = this.max >= 0L ? Math.min(l2, this.max - this.pos) : l2;
        long l4 = this.in.skip(l3);
        this.pos += l4;
        return l4;
    }

    @Override
    public int available() throws IOException {
        return this.max >= 0L && this.pos >= this.max ? 0 : this.in.available();
    }

    public String toString() {
        return this.in.toString();
    }

    @Override
    public void close() throws IOException {
        if (this.propagateClose) {
            this.in.close();
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        this.in.reset();
        this.pos = this.mark;
    }

    @Override
    public synchronized void mark(int n2) {
        this.in.mark(n2);
        this.mark = this.pos;
    }

    @Override
    public boolean markSupported() {
        return this.in.markSupported();
    }

    public boolean isPropagateClose() {
        return this.propagateClose;
    }

    public void setPropagateClose(boolean bl2) {
        this.propagateClose = bl2;
    }
}

