/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util;

import java.util.Arrays;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.StandardCharset;

final class Base64Codec {
    Base64Codec() {
    }

    static int computeEncodedLength(int n2, boolean bl2) {
        if (n2 == 0) {
            return 0;
        }
        if (bl2) {
            int n3 = n2 / 3 << 2;
            int n4 = n2 % 3;
            return n4 == 0 ? n3 : n3 + n4 + 1;
        }
        return (n2 - 1) / 3 + 1 << 2;
    }

    static int tpSelect(int n2, int n3, int n4) {
        int n5 = n2 - 1;
        return n3 ^ n5 & (n3 ^ n4);
    }

    static int tpLT(int n2, int n3) {
        return (int)((long)n2 - (long)n3 >>> 63);
    }

    static int tpGT(int n2, int n3) {
        return (int)((long)n3 - (long)n2 >>> 63);
    }

    static int tpEq(int n2, int n3) {
        int n4 = n2 ^ n3;
        int n5 = n4 - 1 & ~n4;
        return n5 >>> 63;
    }

    static byte encodeDigitBase64(int n2) {
        assert (n2 >= 0 && n2 <= 63);
        int n3 = Base64Codec.tpLT(n2, 26);
        int n4 = Base64Codec.tpGT(n2, 25) & Base64Codec.tpLT(n2, 52);
        int n5 = Base64Codec.tpGT(n2, 51) & Base64Codec.tpLT(n2, 62);
        int n6 = Base64Codec.tpEq(n2, 62);
        int n7 = Base64Codec.tpEq(n2, 63);
        int n8 = n2 - 0 + 65;
        int n9 = n2 - 26 + 97;
        int n10 = n2 - 52 + 48;
        int n11 = 43;
        int n12 = 47;
        int n13 = Base64Codec.tpSelect(n3, n8, 0) | Base64Codec.tpSelect(n4, n9, 0) | Base64Codec.tpSelect(n5, n10, 0) | Base64Codec.tpSelect(n6, 43, 0) | Base64Codec.tpSelect(n7, 47, 0);
        return (byte)n13;
    }

    static byte encodeDigitBase64URL(int n2) {
        assert (n2 >= 0 && n2 <= 63);
        int n3 = Base64Codec.tpLT(n2, 26);
        int n4 = Base64Codec.tpGT(n2, 25) & Base64Codec.tpLT(n2, 52);
        int n5 = Base64Codec.tpGT(n2, 51) & Base64Codec.tpLT(n2, 62);
        int n6 = Base64Codec.tpEq(n2, 62);
        int n7 = Base64Codec.tpEq(n2, 63);
        int n8 = n2 - 0 + 65;
        int n9 = n2 - 26 + 97;
        int n10 = n2 - 52 + 48;
        int n11 = 45;
        int n12 = 95;
        int n13 = Base64Codec.tpSelect(n3, n8, 0) | Base64Codec.tpSelect(n4, n9, 0) | Base64Codec.tpSelect(n5, n10, 0) | Base64Codec.tpSelect(n6, 45, 0) | Base64Codec.tpSelect(n7, 95, 0);
        return (byte)n13;
    }

    static int decodeDigit(byte by2) {
        int n2 = Base64Codec.tpGT(by2, 64) & Base64Codec.tpLT(by2, 91);
        int n3 = Base64Codec.tpGT(by2, 96) & Base64Codec.tpLT(by2, 123);
        int n4 = Base64Codec.tpGT(by2, 47) & Base64Codec.tpLT(by2, 58);
        int n5 = Base64Codec.tpEq(by2, 45) | Base64Codec.tpEq(by2, 43);
        int n6 = Base64Codec.tpEq(by2, 95) | Base64Codec.tpEq(by2, 47);
        int n7 = n2 | n3 | n4 | n5 | n6;
        int n8 = by2 - 65 + 0;
        int n9 = by2 - 97 + 26;
        int n10 = by2 - 48 + 52;
        int n11 = 62;
        int n12 = 63;
        int n13 = Base64Codec.tpSelect(n2, n8, 0) | Base64Codec.tpSelect(n3, n9, 0) | Base64Codec.tpSelect(n4, n10, 0) | Base64Codec.tpSelect(n5, 62, 0) | Base64Codec.tpSelect(n6, 63, 0) | Base64Codec.tpSelect(n7, 0, -1);
        assert (n13 >= -1 && n13 <= 63);
        return n13;
    }

    public static String encodeToString(byte[] byArray, boolean bl2) {
        int n2;
        int n3 = n2 = byArray != null ? byArray.length : 0;
        if (n2 == 0) {
            return "";
        }
        int n4 = n2 / 3 * 3;
        int n5 = Base64Codec.computeEncodedLength(n2, bl2);
        byte[] byArray2 = new byte[n5];
        int n6 = 0;
        int n7 = 0;
        while (n6 < n4) {
            int n8 = (byArray[n6++] & 0xFF) << 16 | (byArray[n6++] & 0xFF) << 8 | byArray[n6++] & 0xFF;
            if (bl2) {
                byArray2[n7++] = Base64Codec.encodeDigitBase64URL(n8 >>> 18 & 0x3F);
                byArray2[n7++] = Base64Codec.encodeDigitBase64URL(n8 >>> 12 & 0x3F);
                byArray2[n7++] = Base64Codec.encodeDigitBase64URL(n8 >>> 6 & 0x3F);
                byArray2[n7++] = Base64Codec.encodeDigitBase64URL(n8 & 0x3F);
                continue;
            }
            byArray2[n7++] = Base64Codec.encodeDigitBase64(n8 >>> 18 & 0x3F);
            byArray2[n7++] = Base64Codec.encodeDigitBase64(n8 >>> 12 & 0x3F);
            byArray2[n7++] = Base64Codec.encodeDigitBase64(n8 >>> 6 & 0x3F);
            byArray2[n7++] = Base64Codec.encodeDigitBase64(n8 & 0x3F);
        }
        n6 = n2 - n4;
        if (n6 > 0) {
            n7 = (byArray[n4] & 0xFF) << 10 | (n6 == 2 ? (byArray[n2 - 1] & 0xFF) << 2 : 0);
            if (bl2) {
                if (n6 == 2) {
                    byArray2[n5 - 3] = Base64Codec.encodeDigitBase64URL(n7 >> 12);
                    byArray2[n5 - 2] = Base64Codec.encodeDigitBase64URL(n7 >>> 6 & 0x3F);
                    byArray2[n5 - 1] = Base64Codec.encodeDigitBase64URL(n7 & 0x3F);
                } else {
                    byArray2[n5 - 2] = Base64Codec.encodeDigitBase64URL(n7 >> 12);
                    byArray2[n5 - 1] = Base64Codec.encodeDigitBase64URL(n7 >>> 6 & 0x3F);
                }
            } else {
                byArray2[n5 - 4] = Base64Codec.encodeDigitBase64(n7 >> 12);
                byArray2[n5 - 3] = Base64Codec.encodeDigitBase64(n7 >>> 6 & 0x3F);
                byArray2[n5 - 2] = n6 == 2 ? (int)Base64Codec.encodeDigitBase64(n7 & 0x3F) : 61;
                byArray2[n5 - 1] = 61;
            }
        }
        return new String(byArray2, StandardCharset.UTF_8);
    }

    public static byte[] decode(String string) {
        if (string == null || string.isEmpty()) {
            return new byte[0];
        }
        byte[] byArray = string.getBytes(StandardCharset.UTF_8);
        int n2 = byArray.length;
        int n3 = Base64Codec.checkedCast((long)n2 * 6L >> 3);
        byte[] byArray2 = new byte[n3];
        int n4 = 0;
        int n5 = 0;
        while (n5 < byArray.length) {
            int n6 = 0;
            int n7 = 0;
            while (n7 < 4 && n5 < n2) {
                int n8;
                if ((n8 = Base64Codec.decodeDigit(byArray[n5++])) < 0) continue;
                n6 |= n8 << 18 - n7 * 6;
                ++n7;
            }
            if (n7 < 2) continue;
            byArray2[n4++] = (byte)(n6 >> 16);
            if (n7 < 3) continue;
            byArray2[n4++] = (byte)(n6 >> 8);
            if (n7 < 4) continue;
            byArray2[n4++] = (byte)n6;
        }
        return Arrays.copyOf(byArray2, n4);
    }

    private static int checkedCast(long l2) {
        int n2 = (int)l2;
        if ((long)n2 != l2) {
            throw new IllegalArgumentException(l2 + " cannot be cast to int without changing its value.");
        }
        return n2;
    }
}

