/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.internal.sql;

import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.Gson;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.JsonSyntaxException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.TypeAdapter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.TypeAdapterFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.reflect.TypeToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.stream.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.stream.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.stream.JsonWriter;

final class SqlDateTypeAdapter
extends TypeAdapter<java.sql.Date> {
    static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        @Override
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            return typeToken.getRawType() == java.sql.Date.class ? new SqlDateTypeAdapter() : null;
        }
    };
    private final DateFormat format = new SimpleDateFormat("MMM d, yyyy");

    private SqlDateTypeAdapter() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public java.sql.Date read(JsonReader jsonReader) throws IOException {
        if (jsonReader.peek() == JsonToken.NULL) {
            jsonReader.nextNull();
            return null;
        }
        String string = jsonReader.nextString();
        SqlDateTypeAdapter sqlDateTypeAdapter = this;
        synchronized (sqlDateTypeAdapter) {
            TimeZone timeZone = this.format.getTimeZone();
            try {
                Date date = this.format.parse(string);
                java.sql.Date date2 = new java.sql.Date(date.getTime());
                return date2;
            }
            catch (ParseException parseException) {
                throw new JsonSyntaxException("Failed parsing '" + string + "' as SQL Date; at path " + jsonReader.getPreviousPath(), parseException);
            }
            finally {
                this.format.setTimeZone(timeZone);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(JsonWriter jsonWriter, java.sql.Date date) throws IOException {
        String string;
        if (date == null) {
            jsonWriter.nullValue();
            return;
        }
        SqlDateTypeAdapter sqlDateTypeAdapter = this;
        synchronized (sqlDateTypeAdapter) {
            string = this.format.format(date);
        }
        jsonWriter.value(string);
    }
}

