/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.internal;

import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.ExclusionStrategy;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.FieldAttributes;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.Gson;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.TypeAdapter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.TypeAdapterFactory;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.annotations.Expose;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.annotations.Since;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.annotations.Until;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.internal.reflect.ReflectionHelper;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.reflect.TypeToken;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.stream.JsonReader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.gson.stream.JsonWriter;

public final class Excluder
implements TypeAdapterFactory,
Cloneable {
    private static final double IGNORE_VERSIONS = -1.0;
    public static final Excluder DEFAULT = new Excluder();
    private double version = -1.0;
    private int modifiers = 136;
    private boolean serializeInnerClasses = true;
    private boolean requireExpose;
    private List<ExclusionStrategy> serializationStrategies = Collections.emptyList();
    private List<ExclusionStrategy> deserializationStrategies = Collections.emptyList();

    protected Excluder clone() {
        try {
            return (Excluder)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new AssertionError((Object)cloneNotSupportedException);
        }
    }

    public Excluder withVersion(double d2) {
        Excluder excluder = this.clone();
        excluder.version = d2;
        return excluder;
    }

    public Excluder withModifiers(int ... nArray) {
        Excluder excluder = this.clone();
        excluder.modifiers = 0;
        for (int n2 : nArray) {
            excluder.modifiers |= n2;
        }
        return excluder;
    }

    public Excluder disableInnerClassSerialization() {
        Excluder excluder = this.clone();
        excluder.serializeInnerClasses = false;
        return excluder;
    }

    public Excluder excludeFieldsWithoutExposeAnnotation() {
        Excluder excluder = this.clone();
        excluder.requireExpose = true;
        return excluder;
    }

    public Excluder withExclusionStrategy(ExclusionStrategy exclusionStrategy, boolean bl2, boolean bl3) {
        Excluder excluder = this.clone();
        if (bl2) {
            excluder.serializationStrategies = new ArrayList<ExclusionStrategy>(this.serializationStrategies);
            excluder.serializationStrategies.add(exclusionStrategy);
        }
        if (bl3) {
            excluder.deserializationStrategies = new ArrayList<ExclusionStrategy>(this.deserializationStrategies);
            excluder.deserializationStrategies.add(exclusionStrategy);
        }
        return excluder;
    }

    @Override
    public <T> TypeAdapter<T> create(final Gson gson, final TypeToken<T> typeToken) {
        Class<T> clazz = typeToken.getRawType();
        final boolean bl2 = this.excludeClass(clazz, true);
        final boolean bl3 = this.excludeClass(clazz, false);
        if (!bl2 && !bl3) {
            return null;
        }
        return new TypeAdapter<T>(){
            private volatile TypeAdapter<T> delegate;

            @Override
            public T read(JsonReader jsonReader) throws IOException {
                if (bl3) {
                    jsonReader.skipValue();
                    return null;
                }
                return this.delegate().read(jsonReader);
            }

            @Override
            public void write(JsonWriter jsonWriter, T t2) throws IOException {
                if (bl2) {
                    jsonWriter.nullValue();
                    return;
                }
                this.delegate().write(jsonWriter, t2);
            }

            private TypeAdapter<T> delegate() {
                TypeAdapter typeAdapter = this.delegate;
                return typeAdapter != null ? typeAdapter : (this.delegate = gson.getDelegateAdapter(Excluder.this, typeToken));
            }
        };
    }

    public boolean excludeField(Field field, boolean bl2) {
        Object object;
        if ((this.modifiers & field.getModifiers()) != 0) {
            return true;
        }
        if (this.version != -1.0 && !this.isValidVersion(field.getAnnotation(Since.class), field.getAnnotation(Until.class))) {
            return true;
        }
        if (field.isSynthetic()) {
            return true;
        }
        if (this.requireExpose && ((object = field.getAnnotation(Expose.class)) == null || (bl2 ? !object.serialize() : !object.deserialize()))) {
            return true;
        }
        if (this.excludeClass(field.getType(), bl2)) {
            return true;
        }
        Object object2 = object = bl2 ? this.serializationStrategies : this.deserializationStrategies;
        if (!object.isEmpty()) {
            FieldAttributes fieldAttributes = new FieldAttributes(field);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ExclusionStrategy exclusionStrategy = (ExclusionStrategy)iterator.next();
                if (!exclusionStrategy.shouldSkipField(fieldAttributes)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean excludeClass(Class<?> clazz, boolean bl2) {
        if (this.version != -1.0 && !this.isValidVersion(clazz.getAnnotation(Since.class), clazz.getAnnotation(Until.class))) {
            return true;
        }
        if (!this.serializeInnerClasses && Excluder.isInnerClass(clazz)) {
            return true;
        }
        if (!bl2 && !Enum.class.isAssignableFrom(clazz) && ReflectionHelper.isAnonymousOrNonStaticLocal(clazz)) {
            return true;
        }
        List<ExclusionStrategy> list = bl2 ? this.serializationStrategies : this.deserializationStrategies;
        for (ExclusionStrategy exclusionStrategy : list) {
            if (!exclusionStrategy.shouldSkipClass(clazz)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && !ReflectionHelper.isStatic(clazz);
    }

    private boolean isValidVersion(Since since, Until until) {
        return this.isValidSince(since) && this.isValidUntil(until);
    }

    private boolean isValidSince(Since since) {
        if (since != null) {
            double d2 = since.value();
            return this.version >= d2;
        }
        return true;
    }

    private boolean isValidUntil(Until until) {
        if (until != null) {
            double d2 = until.value();
            return this.version < d2;
        }
        return true;
    }
}

