/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeySourceException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.AbstractJWKSetSourceEvent;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetCacheRefreshEvaluator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetSourceWrapper;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetUnavailableException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.events.EventListener;

@ThreadSafe
public class RetryingJWKSetSource<C extends SecurityContext>
extends JWKSetSourceWrapper<C> {
    private final EventListener<RetryingJWKSetSource<C>, C> eventListener;

    public RetryingJWKSetSource(JWKSetSource<C> jWKSetSource, EventListener<RetryingJWKSetSource<C>, C> eventListener) {
        super(jWKSetSource);
        this.eventListener = eventListener;
    }

    @Override
    public JWKSet getJWKSet(JWKSetCacheRefreshEvaluator jWKSetCacheRefreshEvaluator, long l2, C c2) throws KeySourceException {
        try {
            return this.getSource().getJWKSet(jWKSetCacheRefreshEvaluator, l2, c2);
        }
        catch (JWKSetUnavailableException jWKSetUnavailableException) {
            if (this.eventListener != null) {
                this.eventListener.notify(new RetrialEvent(this, jWKSetUnavailableException, (SecurityContext)c2, null));
            }
            return this.getSource().getJWKSet(jWKSetCacheRefreshEvaluator, l2, c2);
        }
    }

    public static class RetrialEvent<C extends SecurityContext>
    extends AbstractJWKSetSourceEvent<RetryingJWKSetSource<C>, C> {
        private final Exception exception;

        private RetrialEvent(RetryingJWKSetSource<C> retryingJWKSetSource, Exception exception, C c2) {
            super(retryingJWKSetSource, c2);
            Objects.requireNonNull(exception);
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }

        /* synthetic */ RetrialEvent(RetryingJWKSetSource retryingJWKSetSource, Exception exception, SecurityContext securityContext, 1 var4_4) {
            this(retryingJWKSetSource, exception, securityContext);
        }
    }
}

