/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source;

import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeySourceException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.RemoteKeySourceException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKMatcher;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.DefaultJWKSetCache;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetCache;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.DefaultResourceRetriever;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Resource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.ResourceRetriever;

@ThreadSafe
@Deprecated
public class RemoteJWKSet<C extends SecurityContext>
implements JWKSource<C> {
    public static final int DEFAULT_HTTP_CONNECT_TIMEOUT = 500;
    public static final int DEFAULT_HTTP_READ_TIMEOUT = 500;
    public static final int DEFAULT_HTTP_SIZE_LIMIT = 51200;
    private final URL jwkSetURL;
    private final JWKSource<C> failoverJWKSource;
    private final JWKSetCache jwkSetCache;
    private final ResourceRetriever jwkSetRetriever;

    public static int resolveDefaultHTTPConnectTimeout() {
        return RemoteJWKSet.resolveDefault(RemoteJWKSet.class.getName() + ".defaultHttpConnectTimeout", 500);
    }

    public static int resolveDefaultHTTPReadTimeout() {
        return RemoteJWKSet.resolveDefault(RemoteJWKSet.class.getName() + ".defaultHttpReadTimeout", 500);
    }

    public static int resolveDefaultHTTPSizeLimit() {
        return RemoteJWKSet.resolveDefault(RemoteJWKSet.class.getName() + ".defaultHttpSizeLimit", 51200);
    }

    private static int resolveDefault(String string, int n2) {
        String string2 = System.getProperty(string);
        if (string2 == null) {
            return n2;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    public RemoteJWKSet(URL uRL) {
        this(uRL, (JWKSource)null);
    }

    public RemoteJWKSet(URL uRL, JWKSource<C> jWKSource) {
        this(uRL, jWKSource, null, null);
    }

    public RemoteJWKSet(URL uRL, ResourceRetriever resourceRetriever) {
        this(uRL, resourceRetriever, null);
    }

    public RemoteJWKSet(URL uRL, ResourceRetriever resourceRetriever, JWKSetCache jWKSetCache) {
        this(uRL, null, resourceRetriever, jWKSetCache);
    }

    public RemoteJWKSet(URL uRL, JWKSource<C> jWKSource, ResourceRetriever resourceRetriever, JWKSetCache jWKSetCache) {
        this.jwkSetURL = Objects.requireNonNull(uRL);
        this.failoverJWKSource = jWKSource;
        this.jwkSetRetriever = resourceRetriever != null ? resourceRetriever : new DefaultResourceRetriever(RemoteJWKSet.resolveDefaultHTTPConnectTimeout(), RemoteJWKSet.resolveDefaultHTTPReadTimeout(), RemoteJWKSet.resolveDefaultHTTPSizeLimit());
        this.jwkSetCache = jWKSetCache != null ? jWKSetCache : new DefaultJWKSetCache();
    }

    private JWKSet updateJWKSetFromURL() throws RemoteKeySourceException {
        JWKSet jWKSet;
        Resource resource;
        try {
            resource = this.jwkSetRetriever.retrieveResource(this.jwkSetURL);
        }
        catch (IOException iOException) {
            throw new RemoteKeySourceException("Couldn't retrieve remote JWK set: " + iOException.getMessage(), iOException);
        }
        try {
            jWKSet = JWKSet.parse(resource.getContent());
        }
        catch (ParseException parseException) {
            throw new RemoteKeySourceException("Couldn't parse remote JWK set: " + parseException.getMessage(), parseException);
        }
        this.jwkSetCache.put(jWKSet);
        return jWKSet;
    }

    public URL getJWKSetURL() {
        return this.jwkSetURL;
    }

    public JWKSource<C> getFailoverJWKSource() {
        return this.failoverJWKSource;
    }

    public ResourceRetriever getResourceRetriever() {
        return this.jwkSetRetriever;
    }

    public JWKSetCache getJWKSetCache() {
        return this.jwkSetCache;
    }

    public JWKSet getCachedJWKSet() {
        return this.jwkSetCache.get();
    }

    protected static String getFirstSpecifiedKeyID(JWKMatcher jWKMatcher) {
        Set<String> set = jWKMatcher.getKeyIDs();
        if (set == null || set.isEmpty()) {
            return null;
        }
        for (String string : set) {
            if (string == null) continue;
            return string;
        }
        return null;
    }

    private List<JWK> failover(Exception exception, JWKSelector jWKSelector, C c2) throws RemoteKeySourceException {
        if (this.getFailoverJWKSource() == null) {
            return null;
        }
        try {
            return this.getFailoverJWKSource().get(jWKSelector, c2);
        }
        catch (KeySourceException keySourceException) {
            throw new RemoteKeySourceException(exception.getMessage() + "; Failover JWK source retrieval failed with: " + keySourceException.getMessage(), keySourceException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<JWK> get(JWKSelector jWKSelector, C c2) throws RemoteKeySourceException {
        Object object;
        Object object2;
        JWKSet jWKSet;
        block18: {
            jWKSet = this.jwkSetCache.get();
            if (this.jwkSetCache.requiresRefresh() || jWKSet == null) {
                try {
                    object2 = this;
                    synchronized (object2) {
                        jWKSet = this.jwkSetCache.get();
                        if (this.jwkSetCache.requiresRefresh() || jWKSet == null) {
                            jWKSet = this.updateJWKSetFromURL();
                        }
                    }
                }
                catch (Exception exception) {
                    object = this.failover(exception, jWKSelector, c2);
                    if (object != null) {
                        return object;
                    }
                    if (jWKSet != null) break block18;
                    throw exception;
                }
            }
        }
        if (!(object2 = jWKSelector.select(jWKSet)).isEmpty()) {
            return object2;
        }
        object = RemoteJWKSet.getFirstSpecifiedKeyID(jWKSelector.getMatcher());
        if (object == null) {
            return Collections.emptyList();
        }
        if (jWKSet.getKeyByKeyId((String)object) != null) {
            return Collections.emptyList();
        }
        try {
            RemoteJWKSet remoteJWKSet = this;
            synchronized (remoteJWKSet) {
                jWKSet = jWKSet == this.jwkSetCache.get() ? this.updateJWKSetFromURL() : this.jwkSetCache.get();
            }
        }
        catch (KeySourceException keySourceException) {
            List<JWK> list = this.failover(keySourceException, jWKSelector, c2);
            if (list != null) {
                return list;
            }
            throw keySourceException;
        }
        if (jWKSet == null) {
            return Collections.emptyList();
        }
        return jWKSelector.select(jWKSet);
    }
}

