/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeySourceException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.AbstractJWKSetSourceEvent;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.CachingJWKSetSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetCacheRefreshEvaluator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.cache.CachedObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.events.EventListener;

@ThreadSafe
public class RefreshAheadCachingJWKSetSource<C extends SecurityContext>
extends CachingJWKSetSource<C> {
    private final long refreshAheadTime;
    private final ReentrantLock lazyLock = new ReentrantLock();
    private final ExecutorService executorService;
    private final boolean shutdownExecutorOnClose;
    private final ScheduledExecutorService scheduledExecutorService;
    private volatile long cacheExpiration;
    private ScheduledFuture<?> scheduledRefreshFuture;
    private final EventListener<CachingJWKSetSource<C>, C> eventListener;

    public RefreshAheadCachingJWKSetSource(JWKSetSource<C> jWKSetSource, long l2, long l3, long l4, boolean bl2, EventListener<CachingJWKSetSource<C>, C> eventListener) {
        this(jWKSetSource, l2, l3, l4, bl2, Executors.newSingleThreadExecutor(), true, eventListener);
    }

    public RefreshAheadCachingJWKSetSource(JWKSetSource<C> jWKSetSource, long l2, long l3, long l4, boolean bl2, ExecutorService executorService, boolean bl3, EventListener<CachingJWKSetSource<C>, C> eventListener) {
        super(jWKSetSource, l2, l3, eventListener);
        if (l4 + l3 > l2) {
            throw new IllegalArgumentException("The sum of the refresh-ahead time (" + l4 + "ms) and the cache refresh timeout (" + l3 + "ms) must not exceed the time-to-lived time (" + l2 + "ms)");
        }
        this.refreshAheadTime = l4;
        Objects.requireNonNull(executorService, "The executor service must not be null");
        this.executorService = executorService;
        this.shutdownExecutorOnClose = bl3;
        this.scheduledExecutorService = bl2 ? Executors.newSingleThreadScheduledExecutor() : null;
        this.eventListener = eventListener;
    }

    @Override
    public JWKSet getJWKSet(JWKSetCacheRefreshEvaluator jWKSetCacheRefreshEvaluator, long l2, C c2) throws KeySourceException {
        CachedObject<JWKSet> cachedObject = this.getCachedJWKSet();
        if (cachedObject == null) {
            return this.loadJWKSetBlocking(JWKSetCacheRefreshEvaluator.noRefresh(), l2, c2);
        }
        JWKSet jWKSet = cachedObject.get();
        if (jWKSetCacheRefreshEvaluator.requiresRefresh(jWKSet)) {
            return this.loadJWKSetBlocking(jWKSetCacheRefreshEvaluator, l2, c2);
        }
        if (cachedObject.isExpired(l2)) {
            return this.loadJWKSetBlocking(JWKSetCacheRefreshEvaluator.referenceComparison(jWKSet), l2, c2);
        }
        this.refreshAheadOfExpiration(cachedObject, false, l2, c2);
        return cachedObject.get();
    }

    @Override
    CachedObject<JWKSet> loadJWKSetNotThreadSafe(JWKSetCacheRefreshEvaluator jWKSetCacheRefreshEvaluator, long l2, C c2) throws KeySourceException {
        CachedObject<JWKSet> cachedObject = super.loadJWKSetNotThreadSafe(jWKSetCacheRefreshEvaluator, l2, c2);
        if (this.scheduledExecutorService != null) {
            this.scheduleRefreshAheadOfExpiration(cachedObject, l2, c2);
        }
        return cachedObject;
    }

    void scheduleRefreshAheadOfExpiration(final CachedObject<JWKSet> cachedObject, long l2, C c2) {
        long l3;
        if (this.scheduledRefreshFuture != null) {
            this.scheduledRefreshFuture.cancel(false);
        }
        if ((l3 = cachedObject.getExpirationTime() - l2 - this.refreshAheadTime - this.getCacheRefreshTimeout()) > 0L) {
            RefreshAheadCachingJWKSetSource refreshAheadCachingJWKSetSource = this;
            Runnable runnable = new Runnable(){
                final /* synthetic */ SecurityContext val$context;
                final /* synthetic */ RefreshAheadCachingJWKSetSource val$that;
                {
                    this.val$context = securityContext;
                    this.val$that = refreshAheadCachingJWKSetSource2;
                }

                @Override
                public void run() {
                    block2: {
                        try {
                            RefreshAheadCachingJWKSetSource.this.refreshAheadOfExpiration(cachedObject, true, System.currentTimeMillis(), this.val$context);
                        }
                        catch (Exception exception) {
                            if (RefreshAheadCachingJWKSetSource.this.eventListener == null) break block2;
                            RefreshAheadCachingJWKSetSource.this.eventListener.notify(new ScheduledRefreshFailed<SecurityContext>(this.val$that, exception, this.val$context));
                        }
                    }
                }
            };
            this.scheduledRefreshFuture = this.scheduledExecutorService.schedule(runnable, l3, TimeUnit.MILLISECONDS);
            if (this.eventListener != null) {
                this.eventListener.notify(new RefreshScheduledEvent<C>(this, c2));
            }
        } else if (this.eventListener != null) {
            this.eventListener.notify(new RefreshNotScheduledEvent<C>(this, c2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshAheadOfExpiration(CachedObject<JWKSet> cachedObject, boolean bl2, long l2, C c2) {
        if ((cachedObject.isExpired(l2 + this.refreshAheadTime) || bl2) && this.cacheExpiration < cachedObject.getExpirationTime() && this.lazyLock.tryLock()) {
            try {
                this.lockedRefresh(cachedObject, l2, c2);
            }
            finally {
                this.lazyLock.unlock();
            }
        }
    }

    void lockedRefresh(CachedObject<JWKSet> cachedObject, long l2, C c2) {
        if (this.cacheExpiration < cachedObject.getExpirationTime()) {
            this.cacheExpiration = cachedObject.getExpirationTime();
            final RefreshAheadCachingJWKSetSource refreshAheadCachingJWKSetSource = this;
            Runnable runnable = new Runnable(){
                final /* synthetic */ SecurityContext val$context;
                final /* synthetic */ long val$currentTime;
                {
                    this.val$context = securityContext;
                    this.val$currentTime = l2;
                }

                @Override
                public void run() {
                    block4: {
                        try {
                            if (RefreshAheadCachingJWKSetSource.this.eventListener != null) {
                                RefreshAheadCachingJWKSetSource.this.eventListener.notify(new ScheduledRefreshInitiatedEvent(refreshAheadCachingJWKSetSource, this.val$context, null));
                            }
                            JWKSet jWKSet = RefreshAheadCachingJWKSetSource.this.loadJWKSetBlocking(JWKSetCacheRefreshEvaluator.forceRefresh(), this.val$currentTime, this.val$context);
                            if (RefreshAheadCachingJWKSetSource.this.eventListener != null) {
                                RefreshAheadCachingJWKSetSource.this.eventListener.notify(new ScheduledRefreshCompletedEvent(refreshAheadCachingJWKSetSource, jWKSet, this.val$context, null));
                            }
                        }
                        catch (Throwable throwable) {
                            RefreshAheadCachingJWKSetSource.this.cacheExpiration = -1L;
                            if (RefreshAheadCachingJWKSetSource.this.eventListener == null) break block4;
                            RefreshAheadCachingJWKSetSource.this.eventListener.notify(new UnableToRefreshAheadOfExpirationEvent<SecurityContext>(refreshAheadCachingJWKSetSource, this.val$context));
                        }
                    }
                }
            };
            this.executorService.execute(runnable);
        }
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    ReentrantLock getLazyLock() {
        return this.lazyLock;
    }

    ScheduledFuture<?> getScheduledRefreshFuture() {
        return this.scheduledRefreshFuture;
    }

    @Override
    public void close() throws IOException {
        ScheduledFuture<?> scheduledFuture = this.scheduledRefreshFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
        }
        super.close();
        if (this.shutdownExecutorOnClose) {
            this.executorService.shutdownNow();
            try {
                this.executorService.awaitTermination(this.getCacheRefreshTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
        if (this.scheduledExecutorService != null) {
            this.scheduledExecutorService.shutdownNow();
            try {
                this.scheduledExecutorService.awaitTermination(this.getCacheRefreshTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static class RefreshScheduledEvent<C extends SecurityContext>
    extends AbstractJWKSetSourceEvent<CachingJWKSetSource<C>, C> {
        public RefreshScheduledEvent(RefreshAheadCachingJWKSetSource<C> refreshAheadCachingJWKSetSource, C c2) {
            super(refreshAheadCachingJWKSetSource, c2);
        }
    }

    public static class RefreshNotScheduledEvent<C extends SecurityContext>
    extends AbstractJWKSetSourceEvent<CachingJWKSetSource<C>, C> {
        public RefreshNotScheduledEvent(RefreshAheadCachingJWKSetSource<C> refreshAheadCachingJWKSetSource, C c2) {
            super(refreshAheadCachingJWKSetSource, c2);
        }
    }

    public static class UnableToRefreshAheadOfExpirationEvent<C extends SecurityContext>
    extends AbstractJWKSetSourceEvent<CachingJWKSetSource<C>, C> {
        public UnableToRefreshAheadOfExpirationEvent(CachingJWKSetSource<C> cachingJWKSetSource, C c2) {
            super(cachingJWKSetSource, c2);
        }
    }

    public static class ScheduledRefreshCompletedEvent<C extends SecurityContext>
    extends AbstractJWKSetSourceEvent<CachingJWKSetSource<C>, C> {
        private final JWKSet jwkSet;

        private ScheduledRefreshCompletedEvent(CachingJWKSetSource<C> cachingJWKSetSource, JWKSet jWKSet, C c2) {
            super(cachingJWKSetSource, c2);
            Objects.requireNonNull(jWKSet);
            this.jwkSet = jWKSet;
        }

        public JWKSet getJWKSet() {
            return this.jwkSet;
        }

        /* synthetic */ ScheduledRefreshCompletedEvent(CachingJWKSetSource cachingJWKSetSource, JWKSet jWKSet, SecurityContext securityContext, 1 var4_4) {
            this(cachingJWKSetSource, jWKSet, securityContext);
        }
    }

    public static class ScheduledRefreshInitiatedEvent<C extends SecurityContext>
    extends AbstractJWKSetSourceEvent<CachingJWKSetSource<C>, C> {
        private ScheduledRefreshInitiatedEvent(CachingJWKSetSource<C> cachingJWKSetSource, C c2) {
            super(cachingJWKSetSource, c2);
        }

        /* synthetic */ ScheduledRefreshInitiatedEvent(CachingJWKSetSource cachingJWKSetSource, SecurityContext securityContext, 1 var3_3) {
            this(cachingJWKSetSource, securityContext);
        }
    }

    public static class ScheduledRefreshFailed<C extends SecurityContext>
    extends AbstractJWKSetSourceEvent<CachingJWKSetSource<C>, C> {
        private final Exception exception;

        public ScheduledRefreshFailed(CachingJWKSetSource<C> cachingJWKSetSource, Exception exception, C c2) {
            super(cachingJWKSetSource, c2);
            Objects.requireNonNull(exception);
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

