/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source;

import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeySourceException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.AbstractCachingJWKSetSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.AbstractJWKSetSourceEvent;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetCacheRefreshEvaluator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetUnavailableException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.cache.CachedObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.events.EventListener;

@ThreadSafe
public class OutageTolerantJWKSetSource<C extends SecurityContext>
extends AbstractCachingJWKSetSource<C> {
    private final EventListener<OutageTolerantJWKSetSource<C>, C> eventListener;

    public OutageTolerantJWKSetSource(JWKSetSource<C> jWKSetSource, long l2, EventListener<OutageTolerantJWKSetSource<C>, C> eventListener) {
        super(jWKSetSource, l2);
        this.eventListener = eventListener;
    }

    @Override
    public JWKSet getJWKSet(JWKSetCacheRefreshEvaluator jWKSetCacheRefreshEvaluator, long l2, C c2) throws KeySourceException {
        try {
            JWKSet jWKSet = this.getSource().getJWKSet(jWKSetCacheRefreshEvaluator, l2, c2);
            this.cacheJWKSet(jWKSet, l2);
            return jWKSet;
        }
        catch (JWKSetUnavailableException jWKSetUnavailableException) {
            CachedObject<JWKSet> cachedObject = this.getCachedJWKSet();
            if (cachedObject != null && cachedObject.isValid(l2)) {
                JWKSet jWKSet;
                JWKSet jWKSet2;
                long l3 = cachedObject.getExpirationTime() - l2;
                if (this.eventListener != null) {
                    this.eventListener.notify(new OutageEvent(this, jWKSetUnavailableException, l3, (SecurityContext)c2, null));
                }
                if (!jWKSetCacheRefreshEvaluator.requiresRefresh(jWKSet2 = new JWKSet((jWKSet = cachedObject.get()).getKeys()))) {
                    return jWKSet2;
                }
            }
            throw jWKSetUnavailableException;
        }
    }

    public static class OutageEvent<C extends SecurityContext>
    extends AbstractJWKSetSourceEvent<OutageTolerantJWKSetSource<C>, C> {
        private final Exception exception;
        private final long remainingTime;

        private OutageEvent(OutageTolerantJWKSetSource<C> outageTolerantJWKSetSource, Exception exception, long l2, C c2) {
            super(outageTolerantJWKSetSource, c2);
            Objects.requireNonNull(exception);
            this.exception = exception;
            this.remainingTime = l2;
        }

        public Exception getException() {
            return this.exception;
        }

        public long getRemainingTime() {
            return this.remainingTime;
        }

        /* synthetic */ OutageEvent(OutageTolerantJWKSetSource outageTolerantJWKSetSource, Exception exception, long l2, SecurityContext securityContext, 1 var6_5) {
            this(outageTolerantJWKSetSource, exception, l2, securityContext);
        }
    }
}

