/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source;

import java.io.Closeable;
import java.util.List;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeySourceException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSelector;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.IOUtils;

@ThreadSafe
public class JWKSourceWithFailover<C extends SecurityContext>
implements JWKSource<C>,
Closeable {
    private final JWKSource<C> jwkSource;
    private final JWKSource<C> failoverJWKSource;

    public JWKSourceWithFailover(JWKSource<C> jWKSource, JWKSource<C> jWKSource2) {
        Objects.requireNonNull(jWKSource, "The primary JWK source must not be null");
        this.jwkSource = jWKSource;
        this.failoverJWKSource = jWKSource2;
    }

    private List<JWK> failover(Exception exception, JWKSelector jWKSelector, C c2) throws KeySourceException {
        try {
            return this.failoverJWKSource.get(jWKSelector, c2);
        }
        catch (KeySourceException keySourceException) {
            throw new KeySourceException(exception.getMessage() + "; Failover JWK source retrieval failed with: " + keySourceException.getMessage(), keySourceException);
        }
    }

    @Override
    public List<JWK> get(JWKSelector jWKSelector, C c2) throws KeySourceException {
        try {
            return this.jwkSource.get(jWKSelector, c2);
        }
        catch (Exception exception) {
            return this.failover(exception, jWKSelector, c2);
        }
    }

    @Override
    public void close() {
        if (this.jwkSource instanceof Closeable) {
            IOUtils.closeSilently((Closeable)((Object)this.jwkSource));
        }
        if (this.failoverJWKSource instanceof Closeable) {
            IOUtils.closeSilently((Closeable)((Object)this.failoverJWKSource));
        }
    }
}

