/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeySourceException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKSet;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.AbstractCachingJWKSetSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.AbstractJWKSetSourceEvent;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetCacheRefreshEvaluator;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetSource;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.source.JWKSetUnavailableException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.proc.SecurityContext;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.cache.CachedObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.events.EventListener;

@ThreadSafe
public class CachingJWKSetSource<C extends SecurityContext>
extends AbstractCachingJWKSetSource<C> {
    private final ReentrantLock lock = new ReentrantLock();
    private final long cacheRefreshTimeout;
    private final EventListener<CachingJWKSetSource<C>, C> eventListener;

    public CachingJWKSetSource(JWKSetSource<C> jWKSetSource, long l2, long l3, EventListener<CachingJWKSetSource<C>, C> eventListener) {
        super(jWKSetSource, l2);
        this.cacheRefreshTimeout = l3;
        this.eventListener = eventListener;
    }

    @Override
    public JWKSet getJWKSet(JWKSetCacheRefreshEvaluator jWKSetCacheRefreshEvaluator, long l2, C c2) throws KeySourceException {
        CachedObject<JWKSet> cachedObject = this.getCachedJWKSet();
        if (cachedObject == null) {
            return this.loadJWKSetBlocking(JWKSetCacheRefreshEvaluator.noRefresh(), l2, c2);
        }
        JWKSet jWKSet = cachedObject.get();
        if (jWKSetCacheRefreshEvaluator.requiresRefresh(jWKSet)) {
            return this.loadJWKSetBlocking(jWKSetCacheRefreshEvaluator, l2, c2);
        }
        if (cachedObject.isExpired(l2)) {
            return this.loadJWKSetBlocking(JWKSetCacheRefreshEvaluator.referenceComparison(jWKSet), l2, c2);
        }
        return cachedObject.get();
    }

    public long getCacheRefreshTimeout() {
        return this.cacheRefreshTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    JWKSet loadJWKSetBlocking(JWKSetCacheRefreshEvaluator jWKSetCacheRefreshEvaluator, long l2, C c2) throws KeySourceException {
        try {
            CachedObject<JWKSet> cachedObject;
            block19: {
                if (this.lock.tryLock()) {
                    try {
                        CachedObject<JWKSet> cachedObject2 = this.getCachedJWKSet();
                        if (cachedObject2 == null || jWKSetCacheRefreshEvaluator.requiresRefresh(cachedObject2.get())) {
                            if (this.eventListener != null) {
                                this.eventListener.notify(new RefreshInitiatedEvent(this, this.lock.getQueueLength(), (SecurityContext)c2, null));
                            }
                            CachedObject<JWKSet> cachedObject3 = this.loadJWKSetNotThreadSafe(jWKSetCacheRefreshEvaluator, l2, c2);
                            if (this.eventListener != null) {
                                this.eventListener.notify(new RefreshCompletedEvent(this, cachedObject3.get(), this.lock.getQueueLength(), (SecurityContext)c2, null));
                            }
                            cachedObject = cachedObject3;
                        }
                        cachedObject = cachedObject2;
                    }
                    finally {
                        this.lock.unlock();
                    }
                } else {
                    if (this.eventListener != null) {
                        this.eventListener.notify(new WaitingForRefreshEvent(this, this.lock.getQueueLength(), (SecurityContext)c2, null));
                    }
                    if (!this.lock.tryLock(this.getCacheRefreshTimeout(), TimeUnit.MILLISECONDS)) {
                        if (this.eventListener == null) throw new JWKSetUnavailableException("Timeout while waiting for cache refresh (" + this.cacheRefreshTimeout + "ms exceeded)");
                        this.eventListener.notify(new RefreshTimedOutEvent(this, this.lock.getQueueLength(), (SecurityContext)c2, null));
                        throw new JWKSetUnavailableException("Timeout while waiting for cache refresh (" + this.cacheRefreshTimeout + "ms exceeded)");
                    }
                    try {
                        CachedObject<JWKSet> cachedObject4 = this.getCachedJWKSet();
                        if (cachedObject4 == null || jWKSetCacheRefreshEvaluator.requiresRefresh(cachedObject4.get())) {
                            if (this.eventListener != null) {
                                this.eventListener.notify(new RefreshInitiatedEvent(this, this.lock.getQueueLength(), (SecurityContext)c2, null));
                            }
                            cachedObject = this.loadJWKSetNotThreadSafe(jWKSetCacheRefreshEvaluator, l2, c2);
                            if (this.eventListener != null) {
                                this.eventListener.notify(new RefreshCompletedEvent(this, cachedObject.get(), this.lock.getQueueLength(), (SecurityContext)c2, null));
                            }
                            break block19;
                        }
                        cachedObject = cachedObject4;
                    }
                    finally {
                        this.lock.unlock();
                    }
                }
            }
            if (cachedObject != null && cachedObject.isValid(l2)) {
                return cachedObject.get();
            }
            if (this.eventListener == null) throw new JWKSetUnavailableException("Unable to refresh cache");
            this.eventListener.notify(new UnableToRefreshEvent(this, (SecurityContext)c2, null));
            throw new JWKSetUnavailableException("Unable to refresh cache");
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            throw new JWKSetUnavailableException("Interrupted while waiting for cache refresh", interruptedException);
        }
    }

    CachedObject<JWKSet> loadJWKSetNotThreadSafe(JWKSetCacheRefreshEvaluator jWKSetCacheRefreshEvaluator, long l2, C c2) throws KeySourceException {
        JWKSet jWKSet = this.getSource().getJWKSet(jWKSetCacheRefreshEvaluator, l2, c2);
        return this.cacheJWKSet(jWKSet, l2);
    }

    ReentrantLock getLock() {
        return this.lock;
    }

    public static class RefreshInitiatedEvent<C extends SecurityContext>
    extends AbstractCachingJWKSetSourceEvent<C> {
        private RefreshInitiatedEvent(CachingJWKSetSource<C> cachingJWKSetSource, int n2, C c2) {
            super(cachingJWKSetSource, n2, c2);
        }

        /* synthetic */ RefreshInitiatedEvent(CachingJWKSetSource cachingJWKSetSource, int n2, SecurityContext securityContext, 1 var4_4) {
            this(cachingJWKSetSource, n2, securityContext);
        }
    }

    public static class RefreshCompletedEvent<C extends SecurityContext>
    extends AbstractCachingJWKSetSourceEvent<C> {
        private final JWKSet jwkSet;

        private RefreshCompletedEvent(CachingJWKSetSource<C> cachingJWKSetSource, JWKSet jWKSet, int n2, C c2) {
            super(cachingJWKSetSource, n2, c2);
            Objects.requireNonNull(jWKSet);
            this.jwkSet = jWKSet;
        }

        public JWKSet getJWKSet() {
            return this.jwkSet;
        }

        /* synthetic */ RefreshCompletedEvent(CachingJWKSetSource cachingJWKSetSource, JWKSet jWKSet, int n2, SecurityContext securityContext, 1 var5_5) {
            this(cachingJWKSetSource, jWKSet, n2, securityContext);
        }
    }

    public static class WaitingForRefreshEvent<C extends SecurityContext>
    extends AbstractCachingJWKSetSourceEvent<C> {
        private WaitingForRefreshEvent(CachingJWKSetSource<C> cachingJWKSetSource, int n2, C c2) {
            super(cachingJWKSetSource, n2, c2);
        }

        /* synthetic */ WaitingForRefreshEvent(CachingJWKSetSource cachingJWKSetSource, int n2, SecurityContext securityContext, 1 var4_4) {
            this(cachingJWKSetSource, n2, securityContext);
        }
    }

    public static class RefreshTimedOutEvent<C extends SecurityContext>
    extends AbstractCachingJWKSetSourceEvent<C> {
        private RefreshTimedOutEvent(CachingJWKSetSource<C> cachingJWKSetSource, int n2, C c2) {
            super(cachingJWKSetSource, n2, c2);
        }

        /* synthetic */ RefreshTimedOutEvent(CachingJWKSetSource cachingJWKSetSource, int n2, SecurityContext securityContext, 1 var4_4) {
            this(cachingJWKSetSource, n2, securityContext);
        }
    }

    public static class UnableToRefreshEvent<C extends SecurityContext>
    extends AbstractJWKSetSourceEvent<CachingJWKSetSource<C>, C> {
        private UnableToRefreshEvent(CachingJWKSetSource<C> cachingJWKSetSource, C c2) {
            super(cachingJWKSetSource, c2);
        }

        /* synthetic */ UnableToRefreshEvent(CachingJWKSetSource cachingJWKSetSource, SecurityContext securityContext, 1 var3_3) {
            this(cachingJWKSetSource, securityContext);
        }
    }

    static class AbstractCachingJWKSetSourceEvent<C extends SecurityContext>
    extends AbstractJWKSetSourceEvent<CachingJWKSetSource<C>, C> {
        private final int threadQueueLength;

        public AbstractCachingJWKSetSourceEvent(CachingJWKSetSource<C> cachingJWKSetSource, int n2, C c2) {
            super(cachingJWKSetSource, c2);
            this.threadQueueLength = n2;
        }

        public int getThreadQueueLength() {
            return this.threadQueueLength;
        }
    }
}

