/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.gen;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.Curve;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.ECKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.gen.JWKGenerator;

public class ECKeyGenerator
extends JWKGenerator<ECKey> {
    private final Curve crv;

    public ECKeyGenerator(Curve curve) {
        this.crv = Objects.requireNonNull(curve);
    }

    @Override
    public ECKey generate() throws JOSEException {
        KeyPairGenerator keyPairGenerator;
        ECParameterSpec eCParameterSpec = this.crv.toECParameterSpec();
        try {
            keyPairGenerator = this.keyStore != null ? KeyPairGenerator.getInstance("EC", this.keyStore.getProvider()) : (this.provider != null ? KeyPairGenerator.getInstance("EC", this.provider) : KeyPairGenerator.getInstance("EC"));
            if (this.secureRandom != null) {
                keyPairGenerator.initialize(eCParameterSpec, this.secureRandom);
            } else {
                keyPairGenerator.initialize(eCParameterSpec);
            }
        }
        catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException generalSecurityException) {
            throw new JOSEException(generalSecurityException.getMessage(), generalSecurityException);
        }
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        ECKey.Builder builder = new ECKey.Builder(this.crv, (ECPublicKey)keyPair.getPublic()).privateKey(keyPair.getPrivate()).keyUse(this.use).keyOperations(this.ops).algorithm(this.alg).expirationTime(this.exp).notBeforeTime(this.nbf).issueTime(this.iat).keyStore(this.keyStore);
        if (this.x5tKid) {
            builder.keyIDFromThumbprint();
        } else {
            builder.keyID(this.kid);
        }
        return builder.build();
    }
}

