/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk;

import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAMultiPrimePrivateCrtKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAMultiPrimePrivateCrtKeySpec;
import java.security.spec.RSAOtherPrimeInfo;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPrivateKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Algorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.AsymmetricJWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWKMetadata;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyOperation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyRevocation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.KeyUse;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.ThumbprintUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.Immutable;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.ByteUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.IntegerOverflowException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONArrayUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONObjectUtils;

@Immutable
public final class RSAKey
extends JWK
implements AsymmetricJWK {
    private static final long serialVersionUID = 1L;
    private final Base64URL n;
    private final Base64URL e;
    private final Base64URL d;
    private final Base64URL p;
    private final Base64URL q;
    private final Base64URL dp;
    private final Base64URL dq;
    private final Base64URL qi;
    private final List<OtherPrimesInfo> oth;
    private final PrivateKey privateKey;

    @Deprecated
    public RSAKey(Base64URL base64URL, Base64URL base64URL2, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL3, Base64URL base64URL4, List<Base64> list, KeyStore keyStore) {
        this(base64URL, base64URL2, null, null, null, null, null, null, null, null, keyUse, set, algorithm, string, uRI, base64URL3, base64URL4, list, null, null, null, keyStore);
    }

    @Deprecated
    public RSAKey(Base64URL base64URL, Base64URL base64URL2, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL3, Base64URL base64URL4, List<Base64> list, Date date, Date date2, Date date3, KeyStore keyStore) {
        this(base64URL, base64URL2, null, null, null, null, null, null, null, null, keyUse, set, algorithm, string, uRI, base64URL3, base64URL4, list, date, date2, date3, keyStore);
    }

    public RSAKey(Base64URL base64URL, Base64URL base64URL2, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL3, Base64URL base64URL4, List<Base64> list, Date date, Date date2, Date date3, KeyRevocation keyRevocation, KeyStore keyStore) {
        this(base64URL, base64URL2, null, null, null, null, null, null, null, null, keyUse, set, algorithm, string, uRI, base64URL3, base64URL4, list, date, date2, date3, keyRevocation, keyStore);
    }

    @Deprecated
    public RSAKey(Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL4, Base64URL base64URL5, List<Base64> list, KeyStore keyStore) {
        this(base64URL, base64URL2, base64URL3, null, null, null, null, null, null, null, keyUse, set, algorithm, string, uRI, base64URL4, base64URL5, list, null, null, null, keyStore);
    }

    @Deprecated
    public RSAKey(Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL4, Base64URL base64URL5, List<Base64> list, Date date, Date date2, Date date3, KeyStore keyStore) {
        this(base64URL, base64URL2, base64URL3, keyUse, set, algorithm, string, uRI, base64URL4, base64URL5, list, date, date2, date3, null, keyStore);
    }

    public RSAKey(Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL4, Base64URL base64URL5, List<Base64> list, Date date, Date date2, Date date3, KeyRevocation keyRevocation, KeyStore keyStore) {
        this(base64URL, base64URL2, base64URL3, null, null, null, null, null, null, null, keyUse, set, algorithm, string, uRI, base64URL4, base64URL5, list, date, date2, date3, keyRevocation, keyStore);
        Objects.requireNonNull(base64URL3, "The private exponent must not be null");
    }

    @Deprecated
    public RSAKey(Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4, Base64URL base64URL5, Base64URL base64URL6, Base64URL base64URL7, List<OtherPrimesInfo> list, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL8, Base64URL base64URL9, List<Base64> list2, KeyStore keyStore) {
        this(base64URL, base64URL2, null, base64URL3, base64URL4, base64URL5, base64URL6, base64URL7, list, null, keyUse, set, algorithm, string, uRI, base64URL8, base64URL9, list2, null, null, null, keyStore);
    }

    @Deprecated
    public RSAKey(Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4, Base64URL base64URL5, Base64URL base64URL6, Base64URL base64URL7, List<OtherPrimesInfo> list, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL8, Base64URL base64URL9, List<Base64> list2, Date date, Date date2, Date date3, KeyStore keyStore) {
        this(base64URL, base64URL2, base64URL3, base64URL4, base64URL5, base64URL6, base64URL7, list, keyUse, set, algorithm, string, uRI, base64URL8, base64URL9, list2, date, date2, date3, null, keyStore);
    }

    public RSAKey(Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4, Base64URL base64URL5, Base64URL base64URL6, Base64URL base64URL7, List<OtherPrimesInfo> list, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL8, Base64URL base64URL9, List<Base64> list2, Date date, Date date2, Date date3, KeyRevocation keyRevocation, KeyStore keyStore) {
        this(base64URL, base64URL2, null, base64URL3, base64URL4, base64URL5, base64URL6, base64URL7, list, null, keyUse, set, algorithm, string, uRI, base64URL8, base64URL9, list2, date, date2, date3, keyRevocation, keyStore);
        Objects.requireNonNull(base64URL3, "The first prime factor must not be null");
        Objects.requireNonNull(base64URL4, "The second prime factor must not be null");
        Objects.requireNonNull(base64URL5, "The first factor CRT exponent must not be null");
        Objects.requireNonNull(base64URL6, "The second factor CRT exponent must not be null");
        Objects.requireNonNull(base64URL7, "The first CRT coefficient must not be null");
    }

    @Deprecated
    public RSAKey(Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4, Base64URL base64URL5, Base64URL base64URL6, Base64URL base64URL7, Base64URL base64URL8, List<OtherPrimesInfo> list, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL9, Base64URL base64URL10, List<Base64> list2) {
        this(base64URL, base64URL2, base64URL3, base64URL4, base64URL5, base64URL6, base64URL7, base64URL8, list, null, keyUse, set, algorithm, string, uRI, base64URL9, base64URL10, list2, null);
    }

    @Deprecated
    public RSAKey(Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4, Base64URL base64URL5, Base64URL base64URL6, Base64URL base64URL7, Base64URL base64URL8, List<OtherPrimesInfo> list, PrivateKey privateKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL9, Base64URL base64URL10, List<Base64> list2, KeyStore keyStore) {
        this(base64URL, base64URL2, base64URL3, base64URL4, base64URL5, base64URL6, base64URL7, base64URL8, list, privateKey, keyUse, set, algorithm, string, uRI, base64URL9, base64URL10, list2, null, null, null, keyStore);
    }

    @Deprecated
    public RSAKey(Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4, Base64URL base64URL5, Base64URL base64URL6, Base64URL base64URL7, Base64URL base64URL8, List<OtherPrimesInfo> list, PrivateKey privateKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL9, Base64URL base64URL10, List<Base64> list2, Date date, Date date2, Date date3, KeyStore keyStore) {
        this(base64URL, base64URL2, base64URL3, base64URL4, base64URL5, base64URL6, base64URL7, base64URL8, list, privateKey, keyUse, set, algorithm, string, uRI, base64URL9, base64URL10, list2, date, date2, date3, null, keyStore);
    }

    public RSAKey(Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4, Base64URL base64URL5, Base64URL base64URL6, Base64URL base64URL7, Base64URL base64URL8, List<OtherPrimesInfo> list, PrivateKey privateKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL9, Base64URL base64URL10, List<Base64> list2, Date date, Date date2, Date date3, KeyRevocation keyRevocation, KeyStore keyStore) {
        super(KeyType.RSA, keyUse, set, algorithm, string, uRI, base64URL9, base64URL10, list2, date, date2, date3, keyRevocation, keyStore);
        this.n = Objects.requireNonNull(base64URL, "The modulus value must not be null");
        this.e = Objects.requireNonNull(base64URL2, "The public exponent value must not be null");
        if (this.getParsedX509CertChain() != null && !this.matches(this.getParsedX509CertChain().get(0))) {
            throw new IllegalArgumentException("The public subject key info of the first X.509 certificate in the chain must match the JWK type and public parameters");
        }
        this.d = base64URL3;
        if (base64URL4 != null && base64URL5 != null && base64URL6 != null && base64URL7 != null && base64URL8 != null) {
            this.p = base64URL4;
            this.q = base64URL5;
            this.dp = base64URL6;
            this.dq = base64URL7;
            this.qi = base64URL8;
            this.oth = list != null ? Collections.unmodifiableList(list) : Collections.emptyList();
        } else if (base64URL4 == null && base64URL5 == null && base64URL6 == null && base64URL7 == null && base64URL8 == null && list == null) {
            this.p = null;
            this.q = null;
            this.dp = null;
            this.dq = null;
            this.qi = null;
            this.oth = Collections.emptyList();
        } else {
            if (base64URL4 != null || base64URL5 != null || base64URL6 != null || base64URL7 != null || base64URL8 != null) {
                Objects.requireNonNull(base64URL4, "Incomplete second private (CRT) representation: The first prime factor must not be null");
                Objects.requireNonNull(base64URL5, "Incomplete second private (CRT) representation: The second prime factor must not be null");
                Objects.requireNonNull(base64URL6, "Incomplete second private (CRT) representation: The first factor CRT exponent must not be null");
                Objects.requireNonNull(base64URL7, "Incomplete second private (CRT) representation: The second factor CRT exponent must not be null");
                throw new IllegalArgumentException("Incomplete second private (CRT) representation: The first CRT coefficient must not be null");
            }
            this.p = null;
            this.q = null;
            this.dp = null;
            this.dq = null;
            this.qi = null;
            this.oth = Collections.emptyList();
        }
        this.privateKey = privateKey;
    }

    @Deprecated
    public RSAKey(RSAPublicKey rSAPublicKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, KeyStore keyStore) {
        this(rSAPublicKey, keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, null, null, null, keyStore);
    }

    @Deprecated
    public RSAKey(RSAPublicKey rSAPublicKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, Date date, Date date2, Date date3, KeyStore keyStore) {
        this(rSAPublicKey, keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, date, date2, date3, null, keyStore);
    }

    public RSAKey(RSAPublicKey rSAPublicKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, Date date, Date date2, Date date3, KeyRevocation keyRevocation, KeyStore keyStore) {
        this(Base64URL.encode(rSAPublicKey.getModulus()), Base64URL.encode(rSAPublicKey.getPublicExponent()), keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, date, date2, date3, keyRevocation, keyStore);
    }

    @Deprecated
    public RSAKey(RSAPublicKey rSAPublicKey, RSAPrivateKey rSAPrivateKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, KeyStore keyStore) {
        this(rSAPublicKey, rSAPrivateKey, keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, null, null, null, keyStore);
    }

    @Deprecated
    public RSAKey(RSAPublicKey rSAPublicKey, RSAPrivateKey rSAPrivateKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, Date date, Date date2, Date date3, KeyStore keyStore) {
        this(rSAPublicKey, rSAPrivateKey, keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, date, date2, date3, null, keyStore);
    }

    public RSAKey(RSAPublicKey rSAPublicKey, RSAPrivateKey rSAPrivateKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, Date date, Date date2, Date date3, KeyRevocation keyRevocation, KeyStore keyStore) {
        this(Base64URL.encode(rSAPublicKey.getModulus()), Base64URL.encode(rSAPublicKey.getPublicExponent()), Base64URL.encode(rSAPrivateKey.getPrivateExponent()), keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, date, date2, date3, keyRevocation, keyStore);
    }

    @Deprecated
    public RSAKey(RSAPublicKey rSAPublicKey, RSAPrivateCrtKey rSAPrivateCrtKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, KeyStore keyStore) {
        this(rSAPublicKey, rSAPrivateCrtKey, keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, null, null, null, keyStore);
    }

    @Deprecated
    public RSAKey(RSAPublicKey rSAPublicKey, RSAPrivateCrtKey rSAPrivateCrtKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, Date date, Date date2, Date date3, KeyStore keyStore) {
        this(Base64URL.encode(rSAPublicKey.getModulus()), Base64URL.encode(rSAPublicKey.getPublicExponent()), Base64URL.encode(rSAPrivateCrtKey.getPrivateExponent()), Base64URL.encode(rSAPrivateCrtKey.getPrimeP()), Base64URL.encode(rSAPrivateCrtKey.getPrimeQ()), Base64URL.encode(rSAPrivateCrtKey.getPrimeExponentP()), Base64URL.encode(rSAPrivateCrtKey.getPrimeExponentQ()), Base64URL.encode(rSAPrivateCrtKey.getCrtCoefficient()), null, null, keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, date, date2, date3, keyStore);
    }

    public RSAKey(RSAPublicKey rSAPublicKey, RSAPrivateCrtKey rSAPrivateCrtKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, Date date, Date date2, Date date3, KeyRevocation keyRevocation, KeyStore keyStore) {
        this(Base64URL.encode(rSAPublicKey.getModulus()), Base64URL.encode(rSAPublicKey.getPublicExponent()), Base64URL.encode(rSAPrivateCrtKey.getPrivateExponent()), Base64URL.encode(rSAPrivateCrtKey.getPrimeP()), Base64URL.encode(rSAPrivateCrtKey.getPrimeQ()), Base64URL.encode(rSAPrivateCrtKey.getPrimeExponentP()), Base64URL.encode(rSAPrivateCrtKey.getPrimeExponentQ()), Base64URL.encode(rSAPrivateCrtKey.getCrtCoefficient()), null, null, keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, date, date2, date3, keyRevocation, keyStore);
    }

    @Deprecated
    public RSAKey(RSAPublicKey rSAPublicKey, RSAMultiPrimePrivateCrtKey rSAMultiPrimePrivateCrtKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, KeyStore keyStore) {
        this(rSAPublicKey, rSAMultiPrimePrivateCrtKey, keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, null, null, null, keyStore);
    }

    @Deprecated
    public RSAKey(RSAPublicKey rSAPublicKey, RSAMultiPrimePrivateCrtKey rSAMultiPrimePrivateCrtKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, Date date, Date date2, Date date3, KeyStore keyStore) {
        this(Base64URL.encode(rSAPublicKey.getModulus()), Base64URL.encode(rSAPublicKey.getPublicExponent()), Base64URL.encode(rSAMultiPrimePrivateCrtKey.getPrivateExponent()), Base64URL.encode(rSAMultiPrimePrivateCrtKey.getPrimeP()), Base64URL.encode(rSAMultiPrimePrivateCrtKey.getPrimeQ()), Base64URL.encode(rSAMultiPrimePrivateCrtKey.getPrimeExponentP()), Base64URL.encode(rSAMultiPrimePrivateCrtKey.getPrimeExponentQ()), Base64URL.encode(rSAMultiPrimePrivateCrtKey.getCrtCoefficient()), OtherPrimesInfo.toList(rSAMultiPrimePrivateCrtKey.getOtherPrimeInfo()), null, keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, date, date2, date3, keyStore);
    }

    public RSAKey(RSAPublicKey rSAPublicKey, RSAMultiPrimePrivateCrtKey rSAMultiPrimePrivateCrtKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, Date date, Date date2, Date date3, KeyRevocation keyRevocation, KeyStore keyStore) {
        this(Base64URL.encode(rSAPublicKey.getModulus()), Base64URL.encode(rSAPublicKey.getPublicExponent()), Base64URL.encode(rSAMultiPrimePrivateCrtKey.getPrivateExponent()), Base64URL.encode(rSAMultiPrimePrivateCrtKey.getPrimeP()), Base64URL.encode(rSAMultiPrimePrivateCrtKey.getPrimeQ()), Base64URL.encode(rSAMultiPrimePrivateCrtKey.getPrimeExponentP()), Base64URL.encode(rSAMultiPrimePrivateCrtKey.getPrimeExponentQ()), Base64URL.encode(rSAMultiPrimePrivateCrtKey.getCrtCoefficient()), OtherPrimesInfo.toList(rSAMultiPrimePrivateCrtKey.getOtherPrimeInfo()), null, keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, date, date2, date3, keyRevocation, keyStore);
    }

    @Deprecated
    public RSAKey(RSAPublicKey rSAPublicKey, PrivateKey privateKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, KeyStore keyStore) {
        this(rSAPublicKey, privateKey, keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, null, null, null, keyStore);
    }

    @Deprecated
    public RSAKey(RSAPublicKey rSAPublicKey, PrivateKey privateKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, Date date, Date date2, Date date3, KeyStore keyStore) {
        this(rSAPublicKey, privateKey, keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, date, date2, date3, null, keyStore);
    }

    public RSAKey(RSAPublicKey rSAPublicKey, PrivateKey privateKey, KeyUse keyUse, Set<KeyOperation> set, Algorithm algorithm, String string, URI uRI, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, Date date, Date date2, Date date3, KeyRevocation keyRevocation, KeyStore keyStore) {
        this(Base64URL.encode(rSAPublicKey.getModulus()), Base64URL.encode(rSAPublicKey.getPublicExponent()), null, null, null, null, null, null, null, privateKey, keyUse, set, algorithm, string, uRI, base64URL, base64URL2, list, date, date2, date3, keyRevocation, keyStore);
    }

    public Base64URL getModulus() {
        return this.n;
    }

    public Base64URL getPublicExponent() {
        return this.e;
    }

    public Base64URL getPrivateExponent() {
        return this.d;
    }

    public Base64URL getFirstPrimeFactor() {
        return this.p;
    }

    public Base64URL getSecondPrimeFactor() {
        return this.q;
    }

    public Base64URL getFirstFactorCRTExponent() {
        return this.dp;
    }

    public Base64URL getSecondFactorCRTExponent() {
        return this.dq;
    }

    public Base64URL getFirstCRTCoefficient() {
        return this.qi;
    }

    public List<OtherPrimesInfo> getOtherPrimes() {
        return this.oth;
    }

    public RSAPublicKey toRSAPublicKey() throws JOSEException {
        BigInteger bigInteger = this.n.decodeToBigInteger();
        BigInteger bigInteger2 = this.e.decodeToBigInteger();
        RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger, bigInteger2);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            throw new JOSEException(generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    public RSAPrivateKey toRSAPrivateKey() throws JOSEException {
        Object object;
        RSAPrivateKeySpec rSAPrivateKeySpec;
        if (this.d == null) {
            return null;
        }
        BigInteger bigInteger = this.n.decodeToBigInteger();
        BigInteger bigInteger2 = this.d.decodeToBigInteger();
        if (this.p == null) {
            rSAPrivateKeySpec = new RSAPrivateKeySpec(bigInteger, bigInteger2);
        } else {
            object = this.e.decodeToBigInteger();
            BigInteger bigInteger3 = this.p.decodeToBigInteger();
            BigInteger bigInteger4 = this.q.decodeToBigInteger();
            BigInteger bigInteger5 = this.dp.decodeToBigInteger();
            BigInteger bigInteger6 = this.dq.decodeToBigInteger();
            BigInteger bigInteger7 = this.qi.decodeToBigInteger();
            if (this.oth != null && !this.oth.isEmpty()) {
                RSAOtherPrimeInfo[] rSAOtherPrimeInfoArray = new RSAOtherPrimeInfo[this.oth.size()];
                for (int i2 = 0; i2 < this.oth.size(); ++i2) {
                    OtherPrimesInfo otherPrimesInfo = this.oth.get(i2);
                    BigInteger bigInteger8 = otherPrimesInfo.getPrimeFactor().decodeToBigInteger();
                    BigInteger bigInteger9 = otherPrimesInfo.getFactorCRTExponent().decodeToBigInteger();
                    BigInteger bigInteger10 = otherPrimesInfo.getFactorCRTCoefficient().decodeToBigInteger();
                    rSAOtherPrimeInfoArray[i2] = new RSAOtherPrimeInfo(bigInteger8, bigInteger9, bigInteger10);
                }
                rSAPrivateKeySpec = new RSAMultiPrimePrivateCrtKeySpec(bigInteger, (BigInteger)object, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7, rSAOtherPrimeInfoArray);
            } else {
                rSAPrivateKeySpec = new RSAPrivateCrtKeySpec(bigInteger, (BigInteger)object, bigInteger2, bigInteger3, bigInteger4, bigInteger5, bigInteger6, bigInteger7);
            }
        }
        try {
            object = KeyFactory.getInstance("RSA");
            return (RSAPrivateKey)((KeyFactory)object).generatePrivate(rSAPrivateKeySpec);
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException generalSecurityException) {
            throw new JOSEException(generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    @Override
    public PublicKey toPublicKey() throws JOSEException {
        return this.toRSAPublicKey();
    }

    @Override
    public PrivateKey toPrivateKey() throws JOSEException {
        RSAPrivateKey rSAPrivateKey = this.toRSAPrivateKey();
        if (rSAPrivateKey != null) {
            return rSAPrivateKey;
        }
        return this.privateKey;
    }

    @Override
    public KeyPair toKeyPair() throws JOSEException {
        return new KeyPair(this.toRSAPublicKey(), this.toPrivateKey());
    }

    @Override
    public boolean matches(X509Certificate x509Certificate) {
        RSAPublicKey rSAPublicKey;
        try {
            rSAPublicKey = (RSAPublicKey)this.getParsedX509CertChain().get(0).getPublicKey();
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (!this.e.decodeToBigInteger().equals(rSAPublicKey.getPublicExponent())) {
            return false;
        }
        return this.n.decodeToBigInteger().equals(rSAPublicKey.getModulus());
    }

    @Override
    public LinkedHashMap<String, ?> getRequiredParams() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("e", this.e.toString());
        linkedHashMap.put("kty", this.getKeyType().getValue());
        linkedHashMap.put("n", this.n.toString());
        return linkedHashMap;
    }

    @Override
    public boolean isPrivate() {
        return this.d != null || this.p != null || this.privateKey != null;
    }

    @Override
    public int size() {
        try {
            return ByteUtils.safeBitLength(this.n.decode());
        }
        catch (IntegerOverflowException integerOverflowException) {
            throw new ArithmeticException(integerOverflowException.getMessage());
        }
    }

    @Override
    public RSAKey toPublicJWK() {
        return new RSAKey(this.getModulus(), this.getPublicExponent(), this.getKeyUse(), this.getKeyOperations(), this.getAlgorithm(), this.getKeyID(), this.getX509CertURL(), this.getX509CertThumbprint(), this.getX509CertSHA256Thumbprint(), this.getX509CertChain(), this.getExpirationTime(), this.getNotBeforeTime(), this.getIssueTime(), this.getKeyRevocation(), this.getKeyStore());
    }

    @Override
    public Map<String, Object> toJSONObject() {
        Map<String, Object> map = super.toJSONObject();
        map.put("n", this.n.toString());
        map.put("e", this.e.toString());
        if (this.d != null) {
            map.put("d", this.d.toString());
        }
        if (this.p != null) {
            map.put("p", this.p.toString());
        }
        if (this.q != null) {
            map.put("q", this.q.toString());
        }
        if (this.dp != null) {
            map.put("dp", this.dp.toString());
        }
        if (this.dq != null) {
            map.put("dq", this.dq.toString());
        }
        if (this.qi != null) {
            map.put("qi", this.qi.toString());
        }
        if (this.oth != null && !this.oth.isEmpty()) {
            List<Object> list = JSONArrayUtils.newJSONArray();
            for (OtherPrimesInfo otherPrimesInfo : this.oth) {
                Map<String, Object> map2 = JSONObjectUtils.newJSONObject();
                map2.put("r", otherPrimesInfo.r.toString());
                map2.put("d", otherPrimesInfo.d.toString());
                map2.put("t", otherPrimesInfo.t.toString());
                list.add(map2);
            }
            map.put("oth", list);
        }
        return map;
    }

    public static RSAKey parse(String string) throws ParseException {
        return RSAKey.parse(JSONObjectUtils.parse(string));
    }

    public static RSAKey parse(Map<String, Object> map) throws ParseException {
        List<Object> list;
        if (!KeyType.RSA.equals(JWKMetadata.parseKeyType(map))) {
            throw new ParseException("The key type \"kty\" must be RSA", 0);
        }
        Base64URL base64URL = JSONObjectUtils.getBase64URL(map, "n");
        Base64URL base64URL2 = JSONObjectUtils.getBase64URL(map, "e");
        Base64URL base64URL3 = JSONObjectUtils.getBase64URL(map, "d");
        Base64URL base64URL4 = JSONObjectUtils.getBase64URL(map, "p");
        Base64URL base64URL5 = JSONObjectUtils.getBase64URL(map, "q");
        Base64URL base64URL6 = JSONObjectUtils.getBase64URL(map, "dp");
        Base64URL base64URL7 = JSONObjectUtils.getBase64URL(map, "dq");
        Base64URL base64URL8 = JSONObjectUtils.getBase64URL(map, "qi");
        ArrayList<OtherPrimesInfo> arrayList = null;
        if (map.containsKey("oth") && (list = JSONObjectUtils.getJSONArray(map, "oth")) != null) {
            arrayList = new ArrayList<OtherPrimesInfo>(list.size());
            for (Object object : list) {
                if (!(object instanceof Map)) continue;
                Map map2 = (Map)object;
                Base64URL base64URL9 = JSONObjectUtils.getBase64URL(map2, "r");
                Base64URL base64URL10 = JSONObjectUtils.getBase64URL(map2, "dq");
                Base64URL base64URL11 = JSONObjectUtils.getBase64URL(map2, "t");
                try {
                    arrayList.add(new OtherPrimesInfo(base64URL9, base64URL10, base64URL11));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new ParseException(illegalArgumentException.getMessage(), 0);
                }
            }
        }
        try {
            return new RSAKey(base64URL, base64URL2, base64URL3, base64URL4, base64URL5, base64URL6, base64URL7, base64URL8, arrayList, null, JWKMetadata.parseKeyUse(map), JWKMetadata.parseKeyOperations(map), JWKMetadata.parseAlgorithm(map), JWKMetadata.parseKeyID(map), JWKMetadata.parseX509CertURL(map), JWKMetadata.parseX509CertThumbprint(map), JWKMetadata.parseX509CertSHA256Thumbprint(map), JWKMetadata.parseX509CertChain(map), JWKMetadata.parseExpirationTime(map), JWKMetadata.parseNotBeforeTime(map), JWKMetadata.parseIssueTime(map), JWKMetadata.parseKeyRevocation(map), null);
        }
        catch (Exception exception) {
            throw new ParseException(exception.getMessage(), 0);
        }
    }

    public static RSAKey parse(X509Certificate x509Certificate) throws JOSEException {
        if (!(x509Certificate.getPublicKey() instanceof RSAPublicKey)) {
            throw new JOSEException("The public key of the X.509 certificate is not RSA");
        }
        RSAPublicKey rSAPublicKey = (RSAPublicKey)x509Certificate.getPublicKey();
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            return new Builder(rSAPublicKey).keyUse(KeyUse.from(x509Certificate)).keyID(x509Certificate.getSerialNumber().toString(10)).x509CertChain(Collections.singletonList(Base64.encode(x509Certificate.getEncoded()))).x509CertSHA256Thumbprint(Base64URL.encode(messageDigest.digest(x509Certificate.getEncoded()))).expirationTime(x509Certificate.getNotAfter()).notBeforeTime(x509Certificate.getNotBefore()).build();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new JOSEException("Couldn't encode x5t parameter: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new JOSEException("Couldn't encode x5c parameter: " + certificateEncodingException.getMessage(), certificateEncodingException);
        }
    }

    public static RSAKey load(KeyStore keyStore, String string, char[] cArray) throws KeyStoreException, JOSEException {
        Key key;
        Certificate certificate = keyStore.getCertificate(string);
        if (!(certificate instanceof X509Certificate)) {
            return null;
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        if (!(x509Certificate.getPublicKey() instanceof RSAPublicKey)) {
            throw new JOSEException("Couldn't load RSA JWK: The key algorithm is not RSA");
        }
        RSAKey rSAKey = RSAKey.parse(x509Certificate);
        rSAKey = new Builder(rSAKey).keyID(string).keyStore(keyStore).build();
        try {
            key = keyStore.getKey(string, cArray);
        }
        catch (NoSuchAlgorithmException | UnrecoverableKeyException generalSecurityException) {
            throw new JOSEException("Couldn't retrieve private RSA key (bad pin?): " + generalSecurityException.getMessage(), generalSecurityException);
        }
        if (key instanceof RSAPrivateKey) {
            return new Builder(rSAKey).privateKey((RSAPrivateKey)key).build();
        }
        if (key instanceof PrivateKey && "RSA".equalsIgnoreCase(key.getAlgorithm())) {
            return new Builder(rSAKey).privateKey((PrivateKey)key).build();
        }
        return rSAKey;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RSAKey)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        RSAKey rSAKey = (RSAKey)object;
        return Objects.equals(this.n, rSAKey.n) && Objects.equals(this.e, rSAKey.e) && Objects.equals(this.d, rSAKey.d) && Objects.equals(this.p, rSAKey.p) && Objects.equals(this.q, rSAKey.q) && Objects.equals(this.dp, rSAKey.dp) && Objects.equals(this.dq, rSAKey.dq) && Objects.equals(this.qi, rSAKey.qi) && Objects.equals(this.oth, rSAKey.oth) && Objects.equals(this.privateKey, rSAKey.privateKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.n, this.e, this.d, this.p, this.q, this.dp, this.dq, this.qi, this.oth, this.privateKey);
    }

    @Immutable
    public static class OtherPrimesInfo
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Base64URL r;
        private final Base64URL d;
        private final Base64URL t;

        public OtherPrimesInfo(Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3) {
            this.r = Objects.requireNonNull(base64URL);
            this.d = Objects.requireNonNull(base64URL2);
            this.t = Objects.requireNonNull(base64URL3);
        }

        public OtherPrimesInfo(RSAOtherPrimeInfo rSAOtherPrimeInfo) {
            this.r = Base64URL.encode(rSAOtherPrimeInfo.getPrime());
            this.d = Base64URL.encode(rSAOtherPrimeInfo.getExponent());
            this.t = Base64URL.encode(rSAOtherPrimeInfo.getCrtCoefficient());
        }

        public Base64URL getPrimeFactor() {
            return this.r;
        }

        public Base64URL getFactorCRTExponent() {
            return this.d;
        }

        public Base64URL getFactorCRTCoefficient() {
            return this.t;
        }

        public static List<OtherPrimesInfo> toList(RSAOtherPrimeInfo[] rSAOtherPrimeInfoArray) {
            ArrayList<OtherPrimesInfo> arrayList = new ArrayList<OtherPrimesInfo>();
            if (rSAOtherPrimeInfoArray == null) {
                return arrayList;
            }
            for (RSAOtherPrimeInfo rSAOtherPrimeInfo : rSAOtherPrimeInfoArray) {
                arrayList.add(new OtherPrimesInfo(rSAOtherPrimeInfo));
            }
            return arrayList;
        }
    }

    public static class Builder {
        private final Base64URL n;
        private final Base64URL e;
        private Base64URL d;
        private Base64URL p;
        private Base64URL q;
        private Base64URL dp;
        private Base64URL dq;
        private Base64URL qi;
        private List<OtherPrimesInfo> oth;
        private PrivateKey priv;
        private KeyUse use;
        private Set<KeyOperation> ops;
        private Algorithm alg;
        private String kid;
        private URI x5u;
        @Deprecated
        private Base64URL x5t;
        private Base64URL x5t256;
        private List<Base64> x5c;
        private Date exp;
        private Date nbf;
        private Date iat;
        private KeyRevocation revocation;
        private KeyStore ks;

        public Builder(Base64URL base64URL, Base64URL base64URL2) {
            this.n = Objects.requireNonNull(base64URL);
            this.e = Objects.requireNonNull(base64URL2);
        }

        public Builder(RSAPublicKey rSAPublicKey) {
            this.n = Base64URL.encode(rSAPublicKey.getModulus());
            this.e = Base64URL.encode(rSAPublicKey.getPublicExponent());
        }

        public Builder(RSAKey rSAKey) {
            this.n = rSAKey.n;
            this.e = rSAKey.e;
            this.d = rSAKey.d;
            this.p = rSAKey.p;
            this.q = rSAKey.q;
            this.dp = rSAKey.dp;
            this.dq = rSAKey.dq;
            this.qi = rSAKey.qi;
            this.oth = rSAKey.oth;
            this.priv = rSAKey.privateKey;
            this.use = rSAKey.getKeyUse();
            this.ops = rSAKey.getKeyOperations();
            this.alg = rSAKey.getAlgorithm();
            this.kid = rSAKey.getKeyID();
            this.x5u = rSAKey.getX509CertURL();
            this.x5t = rSAKey.getX509CertThumbprint();
            this.x5t256 = rSAKey.getX509CertSHA256Thumbprint();
            this.x5c = rSAKey.getX509CertChain();
            this.exp = rSAKey.getExpirationTime();
            this.nbf = rSAKey.getNotBeforeTime();
            this.iat = rSAKey.getIssueTime();
            this.revocation = rSAKey.getKeyRevocation();
            this.ks = rSAKey.getKeyStore();
        }

        public Builder privateExponent(Base64URL base64URL) {
            this.d = base64URL;
            return this;
        }

        public Builder privateKey(RSAPrivateKey rSAPrivateKey) {
            if (rSAPrivateKey instanceof RSAPrivateCrtKey) {
                return this.privateKey((RSAPrivateCrtKey)rSAPrivateKey);
            }
            if (rSAPrivateKey instanceof RSAMultiPrimePrivateCrtKey) {
                return this.privateKey((RSAMultiPrimePrivateCrtKey)rSAPrivateKey);
            }
            this.d = rSAPrivateKey != null ? Base64URL.encode(rSAPrivateKey.getPrivateExponent()) : null;
            return this;
        }

        public Builder privateKey(PrivateKey privateKey) {
            if (privateKey instanceof RSAPrivateKey) {
                return this.privateKey((RSAPrivateKey)privateKey);
            }
            if (privateKey != null && !"RSA".equalsIgnoreCase(privateKey.getAlgorithm())) {
                throw new IllegalArgumentException("The private key algorithm must be RSA");
            }
            this.priv = privateKey;
            return this;
        }

        public Builder firstPrimeFactor(Base64URL base64URL) {
            this.p = base64URL;
            return this;
        }

        public Builder secondPrimeFactor(Base64URL base64URL) {
            this.q = base64URL;
            return this;
        }

        public Builder firstFactorCRTExponent(Base64URL base64URL) {
            this.dp = base64URL;
            return this;
        }

        public Builder secondFactorCRTExponent(Base64URL base64URL) {
            this.dq = base64URL;
            return this;
        }

        public Builder firstCRTCoefficient(Base64URL base64URL) {
            this.qi = base64URL;
            return this;
        }

        public Builder otherPrimes(List<OtherPrimesInfo> list) {
            this.oth = list;
            return this;
        }

        public Builder privateKey(RSAPrivateCrtKey rSAPrivateCrtKey) {
            if (rSAPrivateCrtKey != null) {
                this.d = Base64URL.encode(rSAPrivateCrtKey.getPrivateExponent());
                this.p = Base64URL.encode(rSAPrivateCrtKey.getPrimeP());
                this.q = Base64URL.encode(rSAPrivateCrtKey.getPrimeQ());
                this.dp = Base64URL.encode(rSAPrivateCrtKey.getPrimeExponentP());
                this.dq = Base64URL.encode(rSAPrivateCrtKey.getPrimeExponentQ());
                this.qi = Base64URL.encode(rSAPrivateCrtKey.getCrtCoefficient());
            } else {
                this.d = null;
                this.p = null;
                this.q = null;
                this.dp = null;
                this.dq = null;
                this.qi = null;
            }
            return this;
        }

        public Builder privateKey(RSAMultiPrimePrivateCrtKey rSAMultiPrimePrivateCrtKey) {
            if (rSAMultiPrimePrivateCrtKey != null) {
                this.d = Base64URL.encode(rSAMultiPrimePrivateCrtKey.getPrivateExponent());
                this.p = Base64URL.encode(rSAMultiPrimePrivateCrtKey.getPrimeP());
                this.q = Base64URL.encode(rSAMultiPrimePrivateCrtKey.getPrimeQ());
                this.dp = Base64URL.encode(rSAMultiPrimePrivateCrtKey.getPrimeExponentP());
                this.dq = Base64URL.encode(rSAMultiPrimePrivateCrtKey.getPrimeExponentQ());
                this.qi = Base64URL.encode(rSAMultiPrimePrivateCrtKey.getCrtCoefficient());
                this.oth = OtherPrimesInfo.toList(rSAMultiPrimePrivateCrtKey.getOtherPrimeInfo());
            } else {
                this.d = null;
                this.p = null;
                this.q = null;
                this.dp = null;
                this.dq = null;
                this.qi = null;
                this.oth = null;
            }
            return this;
        }

        public Builder keyUse(KeyUse keyUse) {
            this.use = keyUse;
            return this;
        }

        public Builder keyOperations(Set<KeyOperation> set) {
            this.ops = set;
            return this;
        }

        public Builder algorithm(Algorithm algorithm) {
            this.alg = algorithm;
            return this;
        }

        public Builder keyID(String string) {
            this.kid = string;
            return this;
        }

        public Builder keyIDFromThumbprint() throws JOSEException {
            return this.keyIDFromThumbprint("SHA-256");
        }

        public Builder keyIDFromThumbprint(String string) throws JOSEException {
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put("e", this.e.toString());
            linkedHashMap.put("kty", KeyType.RSA.getValue());
            linkedHashMap.put("n", this.n.toString());
            this.kid = ThumbprintUtils.compute(string, linkedHashMap).toString();
            return this;
        }

        public Builder x509CertURL(URI uRI) {
            this.x5u = uRI;
            return this;
        }

        @Deprecated
        public Builder x509CertThumbprint(Base64URL base64URL) {
            this.x5t = base64URL;
            return this;
        }

        public Builder x509CertSHA256Thumbprint(Base64URL base64URL) {
            this.x5t256 = base64URL;
            return this;
        }

        public Builder x509CertChain(List<Base64> list) {
            this.x5c = list;
            return this;
        }

        public Builder expirationTime(Date date) {
            this.exp = date;
            return this;
        }

        public Builder notBeforeTime(Date date) {
            this.nbf = date;
            return this;
        }

        public Builder issueTime(Date date) {
            this.iat = date;
            return this;
        }

        public Builder keyRevocation(KeyRevocation keyRevocation) {
            this.revocation = keyRevocation;
            return this;
        }

        public Builder keyStore(KeyStore keyStore) {
            this.ks = keyStore;
            return this;
        }

        public RSAKey build() {
            try {
                return new RSAKey(this.n, this.e, this.d, this.p, this.q, this.dp, this.dq, this.qi, this.oth, this.priv, this.use, this.ops, this.alg, this.kid, this.x5u, this.x5t, this.x5t256, this.x5c, this.exp, this.nbf, this.iat, this.revocation, this.ks);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalStateException(illegalArgumentException.getMessage(), illegalArgumentException);
            }
        }
    }
}

