/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.HMAC;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.PRFParams;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.ByteUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.IntegerUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.StandardCharset;

public class PBKDF2 {
    public static final int MIN_SALT_LENGTH = 8;
    static final byte[] ZERO_BYTE = new byte[]{0};
    static final long MAX_DERIVED_KEY_LENGTH = 0xFFFFFFFFL;

    public static byte[] formatSalt(JWEAlgorithm jWEAlgorithm, byte[] byArray) throws JOSEException {
        byte[] byArray2 = jWEAlgorithm.toString().getBytes(StandardCharset.UTF_8);
        if (byArray == null) {
            throw new JOSEException("The salt must not be null");
        }
        if (byArray.length < 8) {
            throw new JOSEException("The salt must be at least 8 bytes long");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(byArray2);
            byteArrayOutputStream.write(ZERO_BYTE);
            byteArrayOutputStream.write(byArray);
        }
        catch (IOException iOException) {
            throw new JOSEException(iOException.getMessage(), iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static SecretKey deriveKey(byte[] byArray, byte[] byArray2, int n2, PRFParams pRFParams) throws JOSEException {
        if (byArray2 == null) {
            throw new JOSEException("The formatted salt must not be null");
        }
        if (n2 < 1) {
            throw new JOSEException("The iteration count must be greater than 0");
        }
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, pRFParams.getMACAlgorithm());
        Mac mac = HMAC.getInitMac(secretKeySpec, pRFParams.getMacProvider());
        int n3 = mac.getMacLength();
        if ((long)pRFParams.getDerivedKeyByteLength() > 0xFFFFFFFFL) {
            throw new JOSEException("Derived key too long: " + pRFParams.getDerivedKeyByteLength());
        }
        int n4 = (int)Math.ceil((double)pRFParams.getDerivedKeyByteLength() / (double)n3);
        int n5 = pRFParams.getDerivedKeyByteLength() - (n4 - 1) * n3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 < n4; ++i2) {
            byte[] byArray3 = PBKDF2.extractBlock(byArray2, n2, i2 + 1, mac);
            if (i2 == n4 - 1) {
                byArray3 = ByteUtils.subArray(byArray3, 0, n5);
            }
            byteArrayOutputStream.write(byArray3, 0, byArray3.length);
        }
        return new SecretKeySpec(byteArrayOutputStream.toByteArray(), "AES");
    }

    static byte[] extractBlock(byte[] byArray, int n2, int n3, Mac mac) throws JOSEException {
        if (byArray == null) {
            throw new JOSEException("The formatted salt must not be null");
        }
        if (n2 < 1) {
            throw new JOSEException("The iteration count must be greater than 0");
        }
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        for (int i2 = 1; i2 <= n2; ++i2) {
            byte[] byArray4;
            if (i2 == 1) {
                byte[] byArray5 = ByteUtils.concat(byArray, IntegerUtils.toBytes(n3));
                byArray3 = byArray4 = mac.doFinal(byArray5);
            } else {
                byArray4 = mac.doFinal(byArray2);
                for (int i3 = 0; i3 < byArray4.length; ++i3) {
                    byArray3[i3] = (byte)(byArray4[i3] ^ byArray3[i3]);
                }
            }
            byArray2 = byArray4;
        }
        return byArray3;
    }

    private PBKDF2() {
    }
}

