/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl;

import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Signature;
import java.security.interfaces.ECKey;
import java.security.spec.ECParameterSpec;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ECDSAProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.Curve;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.ECParameterTable;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.ByteUtils;

public class ECDSA {
    public static JWSAlgorithm resolveAlgorithm(ECKey eCKey) throws JOSEException {
        ECParameterSpec eCParameterSpec = eCKey.getParams();
        return ECDSA.resolveAlgorithm(Curve.forECParameterSpec(eCParameterSpec));
    }

    public static JWSAlgorithm resolveAlgorithm(Curve curve) throws JOSEException {
        if (curve == null) {
            throw new JOSEException("The EC key curve is not supported, must be P-256, P-384 or P-521");
        }
        if (Curve.P_256.equals(curve)) {
            return JWSAlgorithm.ES256;
        }
        if (Curve.SECP256K1.equals(curve)) {
            return JWSAlgorithm.ES256K;
        }
        if (Curve.P_384.equals(curve)) {
            return JWSAlgorithm.ES384;
        }
        if (Curve.P_521.equals(curve)) {
            return JWSAlgorithm.ES512;
        }
        throw new JOSEException("Unexpected curve: " + curve);
    }

    public static Signature getSignerAndVerifier(JWSAlgorithm jWSAlgorithm, Provider provider) throws JOSEException {
        String string;
        if (jWSAlgorithm.equals(JWSAlgorithm.ES256)) {
            string = "SHA256withECDSA";
        } else if (jWSAlgorithm.equals(JWSAlgorithm.ES256K)) {
            string = "SHA256withECDSA";
        } else if (jWSAlgorithm.equals(JWSAlgorithm.ES384)) {
            string = "SHA384withECDSA";
        } else if (jWSAlgorithm.equals(JWSAlgorithm.ES512)) {
            string = "SHA512withECDSA";
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWSAlgorithm(jWSAlgorithm, ECDSAProvider.SUPPORTED_ALGORITHMS));
        }
        try {
            if (provider != null) {
                return Signature.getInstance(string, provider);
            }
            return Signature.getInstance(string);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new JOSEException("Unsupported ECDSA algorithm: " + noSuchAlgorithmException.getMessage(), noSuchAlgorithmException);
        }
    }

    public static int getSignatureByteArrayLength(JWSAlgorithm jWSAlgorithm) throws JOSEException {
        if (jWSAlgorithm.equals(JWSAlgorithm.ES256)) {
            return 64;
        }
        if (jWSAlgorithm.equals(JWSAlgorithm.ES256K)) {
            return 64;
        }
        if (jWSAlgorithm.equals(JWSAlgorithm.ES384)) {
            return 96;
        }
        if (jWSAlgorithm.equals(JWSAlgorithm.ES512)) {
            return 132;
        }
        throw new JOSEException(AlgorithmSupportMessage.unsupportedJWSAlgorithm(jWSAlgorithm, ECDSAProvider.SUPPORTED_ALGORITHMS));
    }

    public static byte[] transcodeSignatureToConcat(byte[] byArray, int n2) throws JOSEException {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (byArray.length < 8 || byArray[0] != 48) {
            throw new JOSEException("Invalid ECDSA signature format");
        }
        if (byArray[1] > 0) {
            n7 = 2;
        } else if (byArray[1] == -127) {
            n7 = 3;
        } else {
            throw new JOSEException("Invalid ECDSA signature format");
        }
        for (n6 = n5 = byArray[n7 + 1]; n6 > 0 && byArray[n7 + 2 + n5 - n6] == 0; --n6) {
        }
        for (n4 = n3 = byArray[n7 + 2 + n5 + 1]; n4 > 0 && byArray[n7 + 2 + n5 + 2 + n3 - n4] == 0; --n4) {
        }
        int n8 = Math.max(n6, n4);
        n8 = Math.max(n8, n2 / 2);
        if ((byArray[n7 - 1] & 0xFF) != byArray.length - n7 || (byArray[n7 - 1] & 0xFF) != 2 + n5 + 2 + n3 || byArray[n7] != 2 || byArray[n7 + 2 + n5] != 2) {
            throw new JOSEException("Invalid ECDSA signature format");
        }
        byte[] byArray2 = new byte[2 * n8];
        System.arraycopy(byArray, n7 + 2 + n5 - n6, byArray2, n8 - n6, n6);
        System.arraycopy(byArray, n7 + 2 + n5 + 2 + n3 - n4, byArray2, 2 * n8 - n4, n4);
        return byArray2;
    }

    public static byte[] transcodeSignatureToDER(byte[] byArray) throws JOSEException {
        try {
            int n2;
            byte[] byArray2;
            int n3;
            int n4;
            int n5;
            int n6;
            for (n6 = n5 = byArray.length / 2; n6 > 0 && byArray[n5 - n6] == 0; --n6) {
            }
            int n7 = n6;
            if (byArray[n5 - n6] < 0) {
                ++n7;
            }
            for (n4 = n5; n4 > 0 && byArray[2 * n5 - n4] == 0; --n4) {
            }
            int n8 = n4;
            if (byArray[2 * n5 - n4] < 0) {
                ++n8;
            }
            if ((n3 = 2 + n7 + 2 + n8) > 255) {
                throw new JOSEException("Invalid ECDSA signature format");
            }
            if (n3 < 128) {
                byArray2 = new byte[4 + n7 + 2 + n8];
                n2 = 1;
            } else {
                byArray2 = new byte[5 + n7 + 2 + n8];
                byArray2[1] = -127;
                n2 = 2;
            }
            byArray2[0] = 48;
            byArray2[n2++] = (byte)n3;
            byArray2[n2++] = 2;
            byArray2[n2++] = (byte)n7;
            System.arraycopy(byArray, n5 - n6, byArray2, n2 + n7 - n6, n6);
            n2 += n7;
            byArray2[n2++] = 2;
            byArray2[n2++] = (byte)n8;
            System.arraycopy(byArray, 2 * n5 - n4, byArray2, n2 + n8 - n4, n4);
            return byArray2;
        }
        catch (Exception exception) {
            if (exception instanceof JOSEException) {
                throw exception;
            }
            throw new JOSEException(exception.getMessage(), exception);
        }
    }

    public static void ensureLegalSignature(byte[] byArray, JWSAlgorithm jWSAlgorithm) throws JOSEException {
        if (ByteUtils.isZeroFilled(byArray)) {
            throw new JOSEException("Blank signature");
        }
        Set<Curve> set = Curve.forJWSAlgorithm(jWSAlgorithm);
        if (set == null || set.size() > 1) {
            throw new JOSEException("Unsupported JWS algorithm: " + jWSAlgorithm);
        }
        Curve curve = set.iterator().next();
        ECParameterSpec eCParameterSpec = ECParameterTable.get(curve);
        if (eCParameterSpec == null) {
            throw new JOSEException("Unsupported curve: " + curve);
        }
        int n2 = ECDSA.getSignatureByteArrayLength(jWSAlgorithm);
        if (ECDSA.getSignatureByteArrayLength(jWSAlgorithm) != byArray.length) {
            throw new JOSEException("Illegal signature length");
        }
        int n3 = n2 / 2;
        byte[] byArray2 = ByteUtils.subArray(byArray, 0, n3);
        BigInteger bigInteger = new BigInteger(1, byArray2);
        byte[] byArray3 = ByteUtils.subArray(byArray, n3, n3);
        BigInteger bigInteger2 = new BigInteger(1, byArray3);
        if (bigInteger2.equals(BigInteger.ZERO) || bigInteger.equals(BigInteger.ZERO)) {
            throw new JOSEException("S and R must not be 0");
        }
        BigInteger bigInteger3 = eCParameterSpec.getOrder();
        if (bigInteger3.compareTo(bigInteger) < 1 || bigInteger3.compareTo(bigInteger2) < 1) {
            throw new JOSEException("S and R must not exceed N");
        }
        if (bigInteger.mod(bigInteger3).equals(BigInteger.ZERO) || bigInteger2.mod(bigInteger3).equals(BigInteger.ZERO)) {
            throw new JOSEException("R or S mod N != 0 check failed");
        }
    }

    private ECDSA() {
    }
}

