/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.KeyUtils;

@ThreadSafe
public class AESKW {
    public static byte[] wrapCEK(SecretKey secretKey, SecretKey secretKey2, Provider provider) throws JOSEException {
        try {
            Cipher cipher = provider != null ? Cipher.getInstance("AESWrap", provider) : Cipher.getInstance("AESWrap");
            cipher.init(3, secretKey2);
            return cipher.wrap(secretKey);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | IllegalBlockSizeException | NoSuchPaddingException generalSecurityException) {
            throw new JOSEException("Couldn't wrap AES key: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    public static SecretKey unwrapCEK(SecretKey secretKey, byte[] byArray, Provider provider) throws JOSEException {
        try {
            Cipher cipher = provider != null ? Cipher.getInstance("AESWrap", provider) : Cipher.getInstance("AESWrap");
            cipher.init(4, KeyUtils.toAESKey(secretKey));
            return (SecretKey)cipher.unwrap(byArray, "AES", 3);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException generalSecurityException) {
            throw new JOSEException("Couldn't unwrap AES key: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    private AESKW() {
    }
}

