/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto;

import java.security.PrivateKey;
import java.util.Set;
import javax.crypto.SecretKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.CriticalHeaderParamsAware;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEDecrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AAD;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.CriticalHeaderParamsDeferral;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.JWEHeaderValidation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.RSA1_5;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.RSACryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.RSAKeyUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.RSA_OAEP;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.RSA_OAEP_SHA2;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.RSAKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;

@ThreadSafe
public class RSADecrypter
extends RSACryptoProvider
implements CriticalHeaderParamsAware,
JWEDecrypter {
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();
    private final PrivateKey privateKey;
    private Exception cekDecryptionException;

    public RSADecrypter(PrivateKey privateKey) {
        this(privateKey, null, false);
    }

    public RSADecrypter(RSAKey rSAKey) throws JOSEException {
        this(RSAKeyUtils.toRSAPrivateKey(rSAKey));
    }

    public RSADecrypter(PrivateKey privateKey, Set<String> set) {
        this(privateKey, set, false);
    }

    public RSADecrypter(PrivateKey privateKey, Set<String> set, boolean bl2) {
        super(null);
        int n2;
        if (!privateKey.getAlgorithm().equalsIgnoreCase("RSA")) {
            throw new IllegalArgumentException("The private key algorithm must be RSA");
        }
        if (!bl2 && (n2 = RSAKeyUtils.keyBitLength(privateKey)) > 0 && n2 < 2048) {
            throw new IllegalArgumentException("The RSA key size must be at least 2048 bits");
        }
        this.privateKey = privateKey;
        this.critPolicy.setDeferredCriticalHeaderParams(set);
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Deprecated
    public byte[] decrypt(JWEHeader jWEHeader, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4) throws JOSEException {
        return this.decrypt(jWEHeader, base64URL, base64URL2, base64URL3, base64URL4, AAD.compute(jWEHeader));
    }

    @Override
    public byte[] decrypt(JWEHeader jWEHeader, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4, byte[] byArray) throws JOSEException {
        SecretKey secretKey;
        if (base64URL == null) {
            throw new JOSEException("Missing JWE encrypted key");
        }
        if (base64URL2 == null) {
            throw new JOSEException("Missing JWE initialization vector (IV)");
        }
        if (base64URL4 == null) {
            throw new JOSEException("Missing JWE authentication tag");
        }
        this.critPolicy.ensureHeaderPasses(jWEHeader);
        JWEAlgorithm jWEAlgorithm = JWEHeaderValidation.getAlgorithmAndEnsureNotNull(jWEHeader);
        if (jWEAlgorithm.equals(JWEAlgorithm.RSA1_5)) {
            int n2 = jWEHeader.getEncryptionMethod().cekBitLength();
            SecretKey secretKey2 = ContentCryptoProvider.generateCEK(jWEHeader.getEncryptionMethod(), this.getJCAContext().getSecureRandom());
            try {
                secretKey = RSA1_5.decryptCEK(this.privateKey, base64URL.decode(), n2, this.getJCAContext().getKeyEncryptionProvider());
                if (secretKey == null) {
                    secretKey = secretKey2;
                }
            }
            catch (Exception exception) {
                this.cekDecryptionException = exception;
                secretKey = secretKey2;
            }
            this.cekDecryptionException = null;
        } else if (jWEAlgorithm.equals(JWEAlgorithm.RSA_OAEP)) {
            secretKey = RSA_OAEP.decryptCEK(this.privateKey, base64URL.decode(), this.getJCAContext().getKeyEncryptionProvider());
        } else if (jWEAlgorithm.equals(JWEAlgorithm.RSA_OAEP_256)) {
            secretKey = RSA_OAEP_SHA2.decryptCEK(this.privateKey, base64URL.decode(), 256, this.getJCAContext().getKeyEncryptionProvider());
        } else if (jWEAlgorithm.equals(JWEAlgorithm.RSA_OAEP_384)) {
            secretKey = RSA_OAEP_SHA2.decryptCEK(this.privateKey, base64URL.decode(), 384, this.getJCAContext().getKeyEncryptionProvider());
        } else if (jWEAlgorithm.equals(JWEAlgorithm.RSA_OAEP_512)) {
            secretKey = RSA_OAEP_SHA2.decryptCEK(this.privateKey, base64URL.decode(), 512, this.getJCAContext().getKeyEncryptionProvider());
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(jWEAlgorithm, SUPPORTED_ALGORITHMS));
        }
        return ContentCryptoProvider.decrypt(jWEHeader, byArray, base64URL, base64URL2, base64URL3, base64URL4, secretKey, this.getJCAContext());
    }

    public Exception getCEKDecryptionException() {
        return this.cekDecryptionException;
    }
}

