/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto;

import java.util.Set;
import javax.crypto.SecretKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.CriticalHeaderParamsAware;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEDecrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AAD;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AESKW;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.CriticalHeaderParamsDeferral;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.JWEHeaderValidation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.PBKDF2;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.PRFParams;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.PasswordBasedCryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.StandardCharset;

@ThreadSafe
public class PasswordBasedDecrypter
extends PasswordBasedCryptoProvider
implements CriticalHeaderParamsAware,
JWEDecrypter {
    public static final int MAX_ALLOWED_ITERATION_COUNT = 1000000;
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();

    public PasswordBasedDecrypter(byte[] byArray) {
        super(byArray);
    }

    public PasswordBasedDecrypter(String string) {
        super(string.getBytes(StandardCharset.UTF_8));
    }

    @Override
    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Deprecated
    public byte[] decrypt(JWEHeader jWEHeader, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4) throws JOSEException {
        return this.decrypt(jWEHeader, base64URL, base64URL2, base64URL3, base64URL4, AAD.compute(jWEHeader));
    }

    @Override
    public byte[] decrypt(JWEHeader jWEHeader, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4, byte[] byArray) throws JOSEException {
        if (base64URL == null) {
            throw new JOSEException("Missing JWE encrypted key");
        }
        if (base64URL2 == null) {
            throw new JOSEException("Missing JWE initialization vector (IV)");
        }
        if (base64URL4 == null) {
            throw new JOSEException("Missing JWE authentication tag");
        }
        if (jWEHeader.getPBES2Salt() == null) {
            throw new JOSEException("Missing JWE p2s header parameter");
        }
        byte[] byArray2 = jWEHeader.getPBES2Salt().decode();
        if (jWEHeader.getPBES2Count() < 1) {
            throw new JOSEException("Missing JWE p2c header parameter");
        }
        int n2 = jWEHeader.getPBES2Count();
        if (n2 > 1000000) {
            throw new JOSEException("The JWE p2c header exceeds the maximum allowed 1000000 count");
        }
        this.critPolicy.ensureHeaderPasses(jWEHeader);
        JWEAlgorithm jWEAlgorithm = JWEHeaderValidation.getAlgorithmAndEnsureNotNull(jWEHeader);
        byte[] byArray3 = PBKDF2.formatSalt(jWEAlgorithm, byArray2);
        PRFParams pRFParams = PRFParams.resolve(jWEAlgorithm, this.getJCAContext().getMACProvider());
        SecretKey secretKey = PBKDF2.deriveKey(this.getPassword(), byArray3, n2, pRFParams);
        SecretKey secretKey2 = AESKW.unwrapCEK(secretKey, base64URL.decode(), this.getJCAContext().getKeyEncryptionProvider());
        return ContentCryptoProvider.decrypt(jWEHeader, byArray, base64URL, base64URL2, base64URL3, base64URL4, secretKey2, this.getJCAContext());
    }
}

