/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.crypto.SecretKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSSigner;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeyLengthException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.HMAC;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.MACProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.OctetSequenceKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.ByteUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.StandardCharset;

@ThreadSafe
public class MACSigner
extends MACProvider
implements JWSSigner {
    public static int getMinRequiredSecretLength(JWSAlgorithm jWSAlgorithm) throws JOSEException {
        if (JWSAlgorithm.HS256.equals(jWSAlgorithm)) {
            return 256;
        }
        if (JWSAlgorithm.HS384.equals(jWSAlgorithm)) {
            return 384;
        }
        if (JWSAlgorithm.HS512.equals(jWSAlgorithm)) {
            return 512;
        }
        throw new JOSEException(AlgorithmSupportMessage.unsupportedJWSAlgorithm(jWSAlgorithm, SUPPORTED_ALGORITHMS));
    }

    public static Set<JWSAlgorithm> getCompatibleAlgorithms(int n2) {
        LinkedHashSet<JWSAlgorithm> linkedHashSet = new LinkedHashSet<JWSAlgorithm>();
        if (n2 >= 256) {
            linkedHashSet.add(JWSAlgorithm.HS256);
        }
        if (n2 >= 384) {
            linkedHashSet.add(JWSAlgorithm.HS384);
        }
        if (n2 >= 512) {
            linkedHashSet.add(JWSAlgorithm.HS512);
        }
        return Collections.unmodifiableSet(linkedHashSet);
    }

    public MACSigner(byte[] byArray) throws KeyLengthException {
        super(byArray, MACSigner.getCompatibleAlgorithms(ByteUtils.bitLength(byArray.length)));
    }

    public MACSigner(String string) throws KeyLengthException {
        this(string.getBytes(StandardCharset.UTF_8));
    }

    public MACSigner(SecretKey secretKey) throws KeyLengthException {
        super(secretKey, secretKey.getEncoded() != null ? MACSigner.getCompatibleAlgorithms(ByteUtils.bitLength(secretKey.getEncoded())) : SUPPORTED_ALGORITHMS);
    }

    public MACSigner(OctetSequenceKey octetSequenceKey) throws KeyLengthException {
        this(octetSequenceKey.toByteArray());
    }

    @Override
    public Base64URL sign(JWSHeader jWSHeader, byte[] byArray) throws JOSEException {
        if (this.getSecret() != null) {
            int n2 = MACSigner.getMinRequiredSecretLength(jWSHeader.getAlgorithm());
            if (this.getSecret().length < ByteUtils.byteLength(n2)) {
                throw new KeyLengthException("The secret length for " + jWSHeader.getAlgorithm() + " must be at least " + n2 + " bits");
            }
        }
        String string = MACSigner.getJCAAlgorithmName(jWSHeader.getAlgorithm());
        byte[] byArray2 = HMAC.compute(string, this.getSecretKey(), byArray, this.getJCAContext().getProvider());
        return Base64URL.encode(byArray2);
    }
}

