/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto;

import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPrivateKey;
import java.util.Collections;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.ActionRequiredForJWSCompletionException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.CompletableJWSObjectSigning;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSSigner;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSSignerOption;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ECDSA;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ECDSAProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.opts.OptionUtils;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.opts.UserAuthenticationRequired;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.Curve;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.ECKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;

@ThreadSafe
public class ECDSASigner
extends ECDSAProvider
implements JWSSigner {
    private final PrivateKey privateKey;
    private final Set<JWSSignerOption> opts;

    public ECDSASigner(ECPrivateKey eCPrivateKey) throws JOSEException {
        this(eCPrivateKey, (Set<JWSSignerOption>)null);
    }

    public ECDSASigner(ECPrivateKey eCPrivateKey, Set<JWSSignerOption> set) throws JOSEException {
        super(ECDSA.resolveAlgorithm(eCPrivateKey));
        this.privateKey = eCPrivateKey;
        this.opts = set != null ? set : Collections.emptySet();
    }

    public ECDSASigner(PrivateKey privateKey, Curve curve) throws JOSEException {
        this(privateKey, curve, null);
    }

    public ECDSASigner(PrivateKey privateKey, Curve curve, Set<JWSSignerOption> set) throws JOSEException {
        super(ECDSA.resolveAlgorithm(curve));
        if (!"EC".equalsIgnoreCase(privateKey.getAlgorithm())) {
            throw new IllegalArgumentException("The private key algorithm must be EC");
        }
        this.privateKey = privateKey;
        this.opts = set != null ? set : Collections.emptySet();
    }

    public ECDSASigner(ECKey eCKey) throws JOSEException {
        this(eCKey, null);
    }

    public ECDSASigner(ECKey eCKey, Set<JWSSignerOption> set) throws JOSEException {
        super(ECDSA.resolveAlgorithm(eCKey.getCurve()));
        if (!eCKey.isPrivate()) {
            throw new JOSEException("The EC JWK doesn't contain a private part");
        }
        this.privateKey = eCKey.toPrivateKey();
        this.opts = set != null ? set : Collections.emptySet();
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    @Override
    public Base64URL sign(final JWSHeader jWSHeader, final byte[] byArray) throws JOSEException {
        byte[] byArray2;
        JWSAlgorithm jWSAlgorithm = jWSHeader.getAlgorithm();
        if (!this.supportedJWSAlgorithms().contains(jWSAlgorithm)) {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWSAlgorithm(jWSAlgorithm, this.supportedJWSAlgorithms()));
        }
        try {
            final Signature signature = ECDSA.getSignerAndVerifier(jWSAlgorithm, this.getJCAContext().getProvider());
            signature.initSign(this.privateKey, this.getJCAContext().getSecureRandom());
            if (OptionUtils.optionIsPresent(this.opts, UserAuthenticationRequired.class)) {
                throw new ActionRequiredForJWSCompletionException("Authenticate user to complete signing", UserAuthenticationRequired.getInstance(), new CompletableJWSObjectSigning(){

                    @Override
                    public Signature getInitializedSignature() {
                        return signature;
                    }

                    @Override
                    public Base64URL complete() throws JOSEException {
                        try {
                            signature.update(byArray);
                            byte[] byArray3 = signature.sign();
                            int n2 = ECDSA.getSignatureByteArrayLength(jWSHeader.getAlgorithm());
                            byte[] byArray2 = ECDSA.transcodeSignatureToConcat(byArray3, n2);
                            return Base64URL.encode(byArray2);
                        }
                        catch (SignatureException signatureException) {
                            throw new JOSEException(signatureException.getMessage(), signatureException);
                        }
                    }
                });
            }
            signature.update(byArray);
            byArray2 = signature.sign();
        }
        catch (InvalidKeyException | SignatureException generalSecurityException) {
            throw new JOSEException(generalSecurityException.getMessage(), generalSecurityException);
        }
        int n2 = ECDSA.getSignatureByteArrayLength(jWSHeader.getAlgorithm());
        byte[] byArray3 = ECDSA.transcodeSignatureToConcat(byArray2, n2);
        return Base64URL.encode(byArray3);
    }
}

