/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto;

import java.util.Set;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.CriticalHeaderParamsAware;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEDecrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.KeyLengthException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AAD;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AESCryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AESGCMKW;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AESKW;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AlgorithmSupportMessage;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AuthenticatedCipherText;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.ContentCryptoProvider;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.CriticalHeaderParamsDeferral;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.JWEHeaderValidation;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.OctetSequenceKey;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;

@ThreadSafe
public class AESDecrypter
extends AESCryptoProvider
implements CriticalHeaderParamsAware,
JWEDecrypter {
    private final CriticalHeaderParamsDeferral critPolicy = new CriticalHeaderParamsDeferral();

    public AESDecrypter(SecretKey secretKey) throws KeyLengthException {
        this(secretKey, (Set<String>)null);
    }

    public AESDecrypter(byte[] byArray) throws KeyLengthException {
        this(new SecretKeySpec(byArray, "AES"));
    }

    public AESDecrypter(OctetSequenceKey octetSequenceKey) throws KeyLengthException {
        this(octetSequenceKey.toSecretKey("AES"));
    }

    public AESDecrypter(SecretKey secretKey, Set<String> set) throws KeyLengthException {
        super(secretKey, null);
        this.critPolicy.setDeferredCriticalHeaderParams(set);
    }

    @Override
    public Set<String> getProcessedCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Override
    public Set<String> getDeferredCriticalHeaderParams() {
        return this.critPolicy.getProcessedCriticalHeaderParams();
    }

    @Deprecated
    public byte[] decrypt(JWEHeader jWEHeader, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4) throws JOSEException {
        return this.decrypt(jWEHeader, base64URL, base64URL2, base64URL3, base64URL4, AAD.compute(jWEHeader));
    }

    @Override
    public byte[] decrypt(JWEHeader jWEHeader, Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4, byte[] byArray) throws JOSEException {
        SecretKey secretKey;
        if (base64URL == null) {
            throw new JOSEException("Missing JWE encrypted key");
        }
        if (base64URL2 == null) {
            throw new JOSEException("Missing JWE initialization vector (IV)");
        }
        if (base64URL4 == null) {
            throw new JOSEException("Missing JWE authentication tag");
        }
        JWEAlgorithm jWEAlgorithm = JWEHeaderValidation.getAlgorithmAndEnsureNotNull(jWEHeader);
        this.critPolicy.ensureHeaderPasses(jWEHeader);
        int n2 = jWEHeader.getEncryptionMethod().cekBitLength();
        if (jWEAlgorithm.equals(JWEAlgorithm.A128KW) || jWEAlgorithm.equals(JWEAlgorithm.A192KW) || jWEAlgorithm.equals(JWEAlgorithm.A256KW)) {
            secretKey = AESKW.unwrapCEK(this.getKey(), base64URL.decode(), this.getJCAContext().getKeyEncryptionProvider());
        } else if (jWEAlgorithm.equals(JWEAlgorithm.A128GCMKW) || jWEAlgorithm.equals(JWEAlgorithm.A192GCMKW) || jWEAlgorithm.equals(JWEAlgorithm.A256GCMKW)) {
            if (jWEHeader.getIV() == null) {
                throw new JOSEException("Missing JWE \"iv\" header parameter");
            }
            byte[] byArray2 = jWEHeader.getIV().decode();
            if (jWEHeader.getAuthTag() == null) {
                throw new JOSEException("Missing JWE \"tag\" header parameter");
            }
            byte[] byArray3 = jWEHeader.getAuthTag().decode();
            AuthenticatedCipherText authenticatedCipherText = new AuthenticatedCipherText(base64URL.decode(), byArray3);
            secretKey = AESGCMKW.decryptCEK(this.getKey(), byArray2, authenticatedCipherText, n2, this.getJCAContext().getKeyEncryptionProvider());
        } else {
            throw new JOSEException(AlgorithmSupportMessage.unsupportedJWEAlgorithm(jWEAlgorithm, SUPPORTED_ALGORITHMS));
        }
        return ContentCryptoProvider.decrypt(jWEHeader, byArray, base64URL, base64URL2, base64URL3, base64URL4, secretKey, this.getJCAContext());
    }
}

