/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose;

import java.text.ParseException;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Payload;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.PlainHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;

@ThreadSafe
public class PlainObject
extends JOSEObject {
    private static final long serialVersionUID = 1L;
    private final PlainHeader header;

    public PlainObject(Payload payload) {
        this.setPayload(Objects.requireNonNull(payload));
        this.header = new PlainHeader();
    }

    public PlainObject(PlainHeader plainHeader, Payload payload) {
        this.header = Objects.requireNonNull(plainHeader);
        this.setPayload(Objects.requireNonNull(payload));
    }

    public PlainObject(Base64URL base64URL, Base64URL base64URL2) throws ParseException {
        try {
            this.header = PlainHeader.parse(Objects.requireNonNull(base64URL));
        }
        catch (ParseException parseException) {
            throw new ParseException("Invalid unsecured header: " + parseException.getMessage(), 0);
        }
        this.setPayload(new Payload(Objects.requireNonNull(base64URL2)));
        this.setParsedParts(base64URL, base64URL2, null);
    }

    @Override
    public PlainHeader getHeader() {
        return this.header;
    }

    @Override
    public String serialize() {
        return this.header.toBase64URL().toString() + '.' + this.getPayload().toBase64URL().toString() + '.';
    }

    public static PlainObject parse(String string) throws ParseException {
        Base64URL[] base64URLArray = JOSEObject.split(string);
        if (!base64URLArray[2].toString().isEmpty()) {
            throw new ParseException("Unexpected third Base64URL part", 0);
        }
        return new PlainObject(base64URLArray[0], base64URLArray[1]);
    }
}

