/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose;

import java.text.ParseException;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWECryptoParts;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEDecrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEEncrypter;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEHeader;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Payload;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.crypto.impl.AAD;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.ThreadSafe;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;

@ThreadSafe
public class JWEObject
extends JOSEObject {
    private static final long serialVersionUID = 1L;
    public static final int MAX_COMPRESSED_CIPHER_TEXT_LENGTH = 100000;
    private JWEHeader header;
    private Base64URL encryptedKey;
    private Base64URL iv;
    private Base64URL cipherText;
    private Base64URL authTag;
    private State state;

    public JWEObject(JWEHeader jWEHeader, Payload payload) {
        this.header = Objects.requireNonNull(jWEHeader);
        this.setPayload(Objects.requireNonNull(payload));
        this.encryptedKey = null;
        this.cipherText = null;
        this.state = State.UNENCRYPTED;
    }

    public JWEObject(Base64URL base64URL, Base64URL base64URL2, Base64URL base64URL3, Base64URL base64URL4, Base64URL base64URL5) throws ParseException {
        try {
            this.header = JWEHeader.parse(Objects.requireNonNull(base64URL));
        }
        catch (ParseException parseException) {
            throw new ParseException("Invalid JWE header: " + parseException.getMessage(), 0);
        }
        this.encryptedKey = base64URL2 == null || base64URL2.toString().isEmpty() ? null : base64URL2;
        this.iv = base64URL3 == null || base64URL3.toString().isEmpty() ? null : base64URL3;
        this.cipherText = Objects.requireNonNull(base64URL4);
        this.authTag = base64URL5 == null || base64URL5.toString().isEmpty() ? null : base64URL5;
        this.state = State.ENCRYPTED;
        this.setParsedParts(base64URL, base64URL2, base64URL3, base64URL4, base64URL5);
    }

    @Override
    public JWEHeader getHeader() {
        return this.header;
    }

    public Base64URL getEncryptedKey() {
        return this.encryptedKey;
    }

    public Base64URL getIV() {
        return this.iv;
    }

    public Base64URL getCipherText() {
        return this.cipherText;
    }

    public Base64URL getAuthTag() {
        return this.authTag;
    }

    public State getState() {
        return this.state;
    }

    private void ensureUnencryptedState() {
        if (this.state != State.UNENCRYPTED) {
            throw new IllegalStateException("The JWE object must be in an unencrypted state");
        }
    }

    private void ensureEncryptedState() {
        if (this.state != State.ENCRYPTED) {
            throw new IllegalStateException("The JWE object must be in an encrypted state");
        }
    }

    private void ensureEncryptedOrDecryptedState() {
        if (this.state != State.ENCRYPTED && this.state != State.DECRYPTED) {
            throw new IllegalStateException("The JWE object must be in an encrypted or decrypted state");
        }
    }

    private void ensureJWEEncrypterSupport(JWEEncrypter jWEEncrypter) throws JOSEException {
        if (!jWEEncrypter.supportedJWEAlgorithms().contains(this.getHeader().getAlgorithm())) {
            throw new JOSEException("The " + this.getHeader().getAlgorithm() + " algorithm is not supported by the JWE encrypter: Supported algorithms: " + jWEEncrypter.supportedJWEAlgorithms());
        }
        if (!jWEEncrypter.supportedEncryptionMethods().contains(this.getHeader().getEncryptionMethod())) {
            throw new JOSEException("The " + this.getHeader().getEncryptionMethod() + " encryption method or key size is not supported by the JWE encrypter: Supported methods: " + jWEEncrypter.supportedEncryptionMethods());
        }
    }

    public synchronized void encrypt(JWEEncrypter jWEEncrypter) throws JOSEException {
        JWECryptoParts jWECryptoParts;
        this.ensureUnencryptedState();
        this.ensureJWEEncrypterSupport(jWEEncrypter);
        try {
            jWECryptoParts = jWEEncrypter.encrypt(this.getHeader(), this.getPayload().toBytes(), AAD.compute(this.getHeader()));
        }
        catch (JOSEException jOSEException) {
            throw jOSEException;
        }
        catch (Exception exception) {
            throw new JOSEException(exception.getMessage(), exception);
        }
        if (jWECryptoParts.getHeader() != null) {
            this.header = jWECryptoParts.getHeader();
        }
        this.encryptedKey = jWECryptoParts.getEncryptedKey();
        this.iv = jWECryptoParts.getInitializationVector();
        this.cipherText = jWECryptoParts.getCipherText();
        this.authTag = jWECryptoParts.getAuthenticationTag();
        this.state = State.ENCRYPTED;
    }

    public synchronized void decrypt(JWEDecrypter jWEDecrypter) throws JOSEException {
        this.ensureEncryptedState();
        if (this.getHeader().getCompressionAlgorithm() != null && this.getCipherText().toString().length() > 100000) {
            throw new JOSEException("The JWE compressed cipher text exceeds the maximum allowed length of 100000 characters");
        }
        try {
            this.setPayload(new Payload(jWEDecrypter.decrypt(this.getHeader(), this.getEncryptedKey(), this.getIV(), this.getCipherText(), this.getAuthTag(), AAD.compute(this.getHeader()))));
        }
        catch (JOSEException jOSEException) {
            throw jOSEException;
        }
        catch (Exception exception) {
            throw new JOSEException(exception.getMessage(), exception);
        }
        this.state = State.DECRYPTED;
    }

    @Override
    public String serialize() {
        this.ensureEncryptedOrDecryptedState();
        StringBuilder stringBuilder = new StringBuilder(this.header.toBase64URL().toString());
        stringBuilder.append('.');
        if (this.encryptedKey != null) {
            stringBuilder.append(this.encryptedKey);
        }
        stringBuilder.append('.');
        if (this.iv != null) {
            stringBuilder.append(this.iv);
        }
        stringBuilder.append('.');
        stringBuilder.append(this.cipherText);
        stringBuilder.append('.');
        if (this.authTag != null) {
            stringBuilder.append(this.authTag);
        }
        return stringBuilder.toString();
    }

    public static JWEObject parse(String string) throws ParseException {
        Base64URL[] base64URLArray = JOSEObject.split(string);
        if (base64URLArray.length != 5) {
            throw new ParseException("Unexpected number of Base64URL parts, must be five", 0);
        }
        return new JWEObject(base64URLArray[0], base64URLArray[1], base64URLArray[2], base64URLArray[3], base64URLArray[4]);
    }

    public static enum State {
        UNENCRYPTED,
        ENCRYPTED,
        DECRYPTED;

    }
}

