/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Algorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Header;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWEObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSAlgorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JWSObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Payload;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.PlainObject;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONObjectUtils;

public abstract class JOSEObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String MIME_TYPE_COMPACT = "application/jose; charset=UTF-8";
    @Deprecated
    public static final String MIME_TYPE_JS = "application/jose+json; charset=UTF-8";
    private Payload payload;
    private Base64URL[] parsedParts;

    protected JOSEObject() {
        this.payload = null;
        this.parsedParts = null;
    }

    protected JOSEObject(Payload payload) {
        this.payload = payload;
    }

    public abstract Header getHeader();

    protected void setPayload(Payload payload) {
        this.payload = payload;
    }

    public Payload getPayload() {
        return this.payload;
    }

    protected void setParsedParts(Base64URL ... base64URLArray) {
        this.parsedParts = base64URLArray;
    }

    public Base64URL[] getParsedParts() {
        return this.parsedParts;
    }

    public String getParsedString() {
        if (this.parsedParts == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Base64URL base64URL : this.parsedParts) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('.');
            }
            if (base64URL == null) continue;
            stringBuilder.append(base64URL);
        }
        return stringBuilder.toString();
    }

    public abstract String serialize();

    public static Base64URL[] split(String string) throws ParseException {
        String string2 = string.trim();
        int n2 = string2.indexOf(".");
        if (n2 == -1) {
            throw new ParseException("Invalid serialized unsecured/JWS/JWE object: Missing part delimiters", 0);
        }
        int n3 = string2.indexOf(".", n2 + 1);
        if (n3 == -1) {
            throw new ParseException("Invalid serialized unsecured/JWS/JWE object: Missing second delimiter", 0);
        }
        int n4 = string2.indexOf(".", n3 + 1);
        if (n4 == -1) {
            Base64URL[] base64URLArray = new Base64URL[]{new Base64URL(string2.substring(0, n2)), new Base64URL(string2.substring(n2 + 1, n3)), new Base64URL(string2.substring(n3 + 1))};
            return base64URLArray;
        }
        int n5 = string2.indexOf(".", n4 + 1);
        if (n5 == -1) {
            throw new ParseException("Invalid serialized JWE object: Missing fourth delimiter", 0);
        }
        if (n5 != -1 && string2.indexOf(".", n5 + 1) != -1) {
            throw new ParseException("Invalid serialized unsecured/JWS/JWE object: Too many part delimiters", 0);
        }
        Base64URL[] base64URLArray = new Base64URL[]{new Base64URL(string2.substring(0, n2)), new Base64URL(string2.substring(n2 + 1, n3)), new Base64URL(string2.substring(n3 + 1, n4)), new Base64URL(string2.substring(n4 + 1, n5)), new Base64URL(string2.substring(n5 + 1))};
        return base64URLArray;
    }

    public static JOSEObject parse(String string) throws ParseException {
        Map<String, Object> map;
        Base64URL[] base64URLArray = JOSEObject.split(string);
        try {
            map = JSONObjectUtils.parse(base64URLArray[0].decodeToString());
        }
        catch (ParseException parseException) {
            throw new ParseException("Invalid unsecured/JWS/JWE header: " + parseException.getMessage(), 0);
        }
        Algorithm algorithm = Header.parseAlgorithm(map);
        if (algorithm.equals(Algorithm.NONE)) {
            return PlainObject.parse(string);
        }
        if (algorithm instanceof JWSAlgorithm) {
            return JWSObject.parse(string);
        }
        if (algorithm instanceof JWEAlgorithm) {
            return JWEObject.parse(string);
        }
        throw new AssertionError((Object)("Unexpected algorithm type: " + algorithm));
    }
}

