/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose;

import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Algorithm;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Header;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.JOSEObjectType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.jwk.JWK;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.Base64URL;

abstract class CommonSEHeader
extends Header {
    private static final long serialVersionUID = 1L;
    private final URI jku;
    private final JWK jwk;
    private final URI x5u;
    private final Base64URL x5t;
    private final Base64URL x5t256;
    private final List<Base64> x5c;
    private final String kid;

    protected CommonSEHeader(Algorithm algorithm, JOSEObjectType jOSEObjectType, String string, Set<String> set, URI uRI, JWK jWK, URI uRI2, Base64URL base64URL, Base64URL base64URL2, List<Base64> list, String string2, Map<String, Object> map, Base64URL base64URL3) {
        super(algorithm, jOSEObjectType, string, set, map, base64URL3);
        this.jku = uRI;
        this.jwk = jWK;
        this.x5u = uRI2;
        this.x5t = base64URL;
        this.x5t256 = base64URL2;
        this.x5c = list != null ? Collections.unmodifiableList(new ArrayList<Base64>(list)) : null;
        this.kid = string2;
    }

    public URI getJWKURL() {
        return this.jku;
    }

    public JWK getJWK() {
        return this.jwk;
    }

    public URI getX509CertURL() {
        return this.x5u;
    }

    @Deprecated
    public Base64URL getX509CertThumbprint() {
        return this.x5t;
    }

    public Base64URL getX509CertSHA256Thumbprint() {
        return this.x5t256;
    }

    public List<Base64> getX509CertChain() {
        return this.x5c;
    }

    public String getKeyID() {
        return this.kid;
    }

    @Override
    public Set<String> getIncludedParams() {
        Set<String> set = super.getIncludedParams();
        if (this.jku != null) {
            set.add("jku");
        }
        if (this.jwk != null) {
            set.add("jwk");
        }
        if (this.x5u != null) {
            set.add("x5u");
        }
        if (this.x5t != null) {
            set.add("x5t");
        }
        if (this.x5t256 != null) {
            set.add("x5t#S256");
        }
        if (this.x5c != null && !this.x5c.isEmpty()) {
            set.add("x5c");
        }
        if (this.kid != null) {
            set.add("kid");
        }
        return set;
    }

    @Override
    public Map<String, Object> toJSONObject() {
        Map<String, Object> map = super.toJSONObject();
        if (this.jku != null) {
            map.put("jku", this.jku.toString());
        }
        if (this.jwk != null) {
            map.put("jwk", this.jwk.toJSONObject());
        }
        if (this.x5u != null) {
            map.put("x5u", this.x5u.toString());
        }
        if (this.x5t != null) {
            map.put("x5t", this.x5t.toString());
        }
        if (this.x5t256 != null) {
            map.put("x5t#S256", this.x5t256.toString());
        }
        if (this.x5c != null && !this.x5c.isEmpty()) {
            ArrayList<String> arrayList = new ArrayList<String>(this.x5c.size());
            for (Base64 base64 : this.x5c) {
                arrayList.add(base64.toString());
            }
            map.put("x5c", arrayList);
        }
        if (this.kid != null) {
            map.put("kid", this.kid);
        }
        return map;
    }

    static JWK parsePublicJWK(Map<String, Object> map) throws ParseException {
        if (map == null) {
            return null;
        }
        JWK jWK = JWK.parse(map);
        if (jWK.isPrivate()) {
            throw new ParseException("Non-public key in jwk header parameter", 0);
        }
        return jWK;
    }
}

