/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.jose;

import java.io.Serializable;
import java.util.Objects;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.Requirement;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.shaded.jcip.Immutable;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.jose.util.JSONStringUtils;

@Immutable
public class Algorithm
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final Algorithm NONE = new Algorithm("none", Requirement.REQUIRED);
    private final String name;
    private final Requirement requirement;

    public Algorithm(String string, Requirement requirement) {
        this.name = Objects.requireNonNull(string);
        this.requirement = requirement;
    }

    public Algorithm(String string) {
        this(string, null);
    }

    public final String getName() {
        return this.name;
    }

    public final Requirement getRequirement() {
        return this.requirement;
    }

    public final int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof Algorithm && this.toString().equals(object.toString());
    }

    public final String toString() {
        return this.name;
    }

    public final String toJSONString() {
        return JSONStringUtils.toJSONString(this.name);
    }

    public static Algorithm parse(String string) {
        if (string == null) {
            return null;
        }
        return new Algorithm(string);
    }
}

