/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.nimbusds.common.contenttype;

import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.StringTokenizer;

public final class ContentType {
    public static final ContentType APPLICATION_JSON = new ContentType("application", "json", Parameter.CHARSET_UTF_8);
    public static final ContentType APPLICATION_JOSE = new ContentType("application", "jose", Parameter.CHARSET_UTF_8);
    public static final ContentType APPLICATION_JWT = new ContentType("application", "jwt", Parameter.CHARSET_UTF_8);
    public static final ContentType APPLICATION_URLENCODED = new ContentType("application", "x-www-form-urlencoded", Parameter.CHARSET_UTF_8);
    public static final ContentType TEXT_PLAIN = new ContentType("text", "plain", Parameter.CHARSET_UTF_8);
    public static final ContentType IMAGE_APNG = new ContentType("image", "apng", new Parameter[0]);
    public static final ContentType IMAGE_AVIF = new ContentType("image", "avif", new Parameter[0]);
    public static final ContentType IMAGE_GIF = new ContentType("image", "gif", new Parameter[0]);
    public static final ContentType IMAGE_JPEG = new ContentType("image", "jpeg", new Parameter[0]);
    public static final ContentType IMAGE_PNG = new ContentType("image", "png", new Parameter[0]);
    public static final ContentType IMAGE_SVG_XML = new ContentType("image", "svg+xml", new Parameter[0]);
    public static final ContentType IMAGE_WEBP = new ContentType("image", "webp", new Parameter[0]);
    public static final ContentType APPLICATION_PDF = new ContentType("application", "pdf", new Parameter[0]);
    private final String baseType;
    private final String subType;
    private final List<Parameter> params;

    public ContentType(String string, String string2, Parameter ... parameterArray) {
        if (string == null || string.trim().isEmpty()) {
            throw new IllegalArgumentException("The base type must be specified");
        }
        this.baseType = string;
        if (string2 == null || string2.trim().isEmpty()) {
            throw new IllegalArgumentException("The subtype must be specified");
        }
        this.subType = string2;
        this.params = parameterArray != null && parameterArray.length > 0 ? Collections.unmodifiableList(Arrays.asList(parameterArray)) : Collections.emptyList();
    }

    public ContentType(String string, String string2, Charset charset) {
        this(string, string2, new Parameter("charset", charset.toString()));
    }

    public String getBaseType() {
        return this.baseType;
    }

    public String getSubType() {
        return this.subType;
    }

    public String getType() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getBaseType());
        stringBuilder.append("/");
        stringBuilder.append(this.getSubType());
        return stringBuilder.toString();
    }

    public List<Parameter> getParameters() {
        return this.params;
    }

    public boolean matches(ContentType contentType) {
        return contentType != null && this.getBaseType().equalsIgnoreCase(contentType.getBaseType()) && this.getSubType().equalsIgnoreCase(contentType.getSubType());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getType());
        if (!this.getParameters().isEmpty()) {
            for (Parameter parameter : this.getParameters()) {
                stringBuilder.append("; ");
                stringBuilder.append(parameter.getName());
                stringBuilder.append("=");
                stringBuilder.append(parameter.getValue());
            }
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ContentType)) {
            return false;
        }
        ContentType contentType = (ContentType)object;
        return this.getBaseType().equalsIgnoreCase(contentType.getBaseType()) && this.getSubType().equalsIgnoreCase(contentType.getSubType()) && this.params.equals(contentType.params);
    }

    public int hashCode() {
        return Objects.hash(this.getBaseType().toLowerCase(), this.getSubType().toLowerCase(), this.params);
    }

    public static ContentType parse(String string) throws ParseException {
        if (string == null || string.trim().isEmpty()) {
            throw new ParseException("Null or empty content type string", 0);
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        if (!stringTokenizer.hasMoreTokens()) {
            throw new ParseException("Invalid content type string", 0);
        }
        String string2 = stringTokenizer.nextToken().trim();
        if (string2.trim().isEmpty()) {
            throw new ParseException("Invalid content type string", 0);
        }
        if (!stringTokenizer.hasMoreTokens()) {
            throw new ParseException("Invalid content type string", 0);
        }
        String string3 = stringTokenizer.nextToken().trim();
        if (!(stringTokenizer = new StringTokenizer(string3, ";")).hasMoreTokens()) {
            return new ContentType(string2, string3.trim(), new Parameter[0]);
        }
        String string4 = stringTokenizer.nextToken().trim();
        if (!stringTokenizer.hasMoreTokens()) {
            return new ContentType(string2, string4, new Parameter[0]);
        }
        LinkedList<Parameter> linkedList = new LinkedList<Parameter>();
        while (stringTokenizer.hasMoreTokens()) {
            String string5 = stringTokenizer.nextToken().trim();
            StringTokenizer stringTokenizer2 = new StringTokenizer(string5, "=");
            if (!stringTokenizer2.hasMoreTokens()) {
                throw new ParseException("Invalid parameter", 0);
            }
            String string6 = stringTokenizer2.nextToken().trim();
            if (!stringTokenizer2.hasMoreTokens()) {
                throw new ParseException("Invalid parameter", 0);
            }
            String string7 = stringTokenizer2.nextToken().trim();
            try {
                linkedList.add(new Parameter(string6, string7));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new ParseException("Invalid parameter: " + illegalArgumentException.getMessage(), 0);
            }
        }
        return new ContentType(string2, string4, linkedList.toArray(new Parameter[0]));
    }

    public static final class Parameter {
        public static final Parameter CHARSET_UTF_8 = new Parameter("charset", "UTF-8");
        private final String name;
        private final String value;

        public Parameter(String string, String string2) {
            if (string == null || string.trim().isEmpty()) {
                throw new IllegalArgumentException("The parameter name must be specified");
            }
            this.name = string;
            if (string2 == null || string2.trim().isEmpty()) {
                throw new IllegalArgumentException("The parameter value must be specified");
            }
            this.value = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.name + "=" + this.value;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Parameter)) {
                return false;
            }
            Parameter parameter = (Parameter)object;
            return this.getName().equalsIgnoreCase(parameter.getName()) && this.getValue().equalsIgnoreCase(parameter.getValue());
        }

        public int hashCode() {
            return Objects.hash(this.getName().toLowerCase(), this.getValue().toLowerCase());
        }
    }
}

