/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;

class XmsClientTelemetryInfo {
    private static final String EXPECTED_HEADER_VERSION = "1";
    private static final int ERROR_CODE_INDEX = 1;
    private static final int SUB_ERROR_CODE_INDEX = 2;
    private static final int TOKEN_AGE_INDEX = 3;
    private static final int SPE_INFO_INDEX = 4;
    private String serverErrorCode;
    private String serverSubErrorCode;
    private String tokenAge;
    private String speInfo;

    XmsClientTelemetryInfo() {
    }

    static XmsClientTelemetryInfo parseXmsTelemetryInfo(String string) {
        if (StringHelper.isBlank(string)) {
            return null;
        }
        String[] stringArray = string.split(",");
        if (stringArray.length == 0) {
            return null;
        }
        String string2 = stringArray[0];
        XmsClientTelemetryInfo xmsClientTelemetryInfo = new XmsClientTelemetryInfo();
        if (!string2.equals(EXPECTED_HEADER_VERSION)) {
            return null;
        }
        Matcher matcher = XmsClientTelemetryInfo.matchHeaderToExpectedFormat(string);
        if (!matcher.matches()) {
            return xmsClientTelemetryInfo;
        }
        stringArray = string.split(",", 5);
        xmsClientTelemetryInfo.serverErrorCode = stringArray[1];
        xmsClientTelemetryInfo.serverSubErrorCode = stringArray[2];
        xmsClientTelemetryInfo.tokenAge = stringArray[3];
        xmsClientTelemetryInfo.speInfo = stringArray[4];
        return xmsClientTelemetryInfo;
    }

    private static Matcher matchHeaderToExpectedFormat(String string) {
        String string2 = "^[1-9]+\\.?[0-9|\\.]*,[0-9|\\.]*,[0-9|\\.]*,[^,]*[0-9\\.]*,[^,]*$";
        Pattern pattern = Pattern.compile(string2);
        return pattern.matcher(string);
    }

    public String getServerErrorCode() {
        return this.serverErrorCode;
    }

    public String getServerSubErrorCode() {
        return this.serverSubErrorCode;
    }

    public String getTokenAge() {
        return this.tokenAge;
    }

    public String getSpeInfo() {
        return this.speInfo;
    }
}

