/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractManagedIdentitySource;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.DefaultHttpClientManagedIdentity;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IEnvironmentVariables;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IHttpClient;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IHttpResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentityApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentityIdType;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentityParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentityResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentitySourceType;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalServiceException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ServiceBundle;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Logger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.LoggerFactory;

class ServiceFabricManagedIdentitySource
extends AbstractManagedIdentitySource {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceFabricManagedIdentitySource.class);
    private static final String SERVICE_FABRIC_MSI_API_VERSION = "2019-07-01-preview";
    private final URI msiEndpoint;
    private final String identityHeader;
    private final ManagedIdentityIdType idType;
    private final String userAssignedId;
    private final IHttpClient httpClient = new DefaultHttpClientManagedIdentity(null, null, null, null);
    private final HttpHelper httpHelper = new HttpHelper(this.httpClient);

    @Override
    public void createManagedIdentityRequest(String string) {
        this.managedIdentityRequest.baseEndpoint = this.msiEndpoint;
        this.managedIdentityRequest.method = HttpMethod.GET;
        this.managedIdentityRequest.headers = new HashMap<String, String>();
        this.managedIdentityRequest.headers.put("secret", this.identityHeader);
        this.managedIdentityRequest.queryParameters = new HashMap<String, List<String>>();
        this.managedIdentityRequest.queryParameters.put("resource", Collections.singletonList(string));
        this.managedIdentityRequest.queryParameters.put("api-version", Collections.singletonList(SERVICE_FABRIC_MSI_API_VERSION));
        if (this.idType == ManagedIdentityIdType.CLIENT_ID) {
            LOG.info("[Managed Identity] Adding user assigned client id to the request for Service Fabric Managed Identity.");
            this.managedIdentityRequest.queryParameters.put("client_id", Collections.singletonList(this.userAssignedId));
        } else if (this.idType == ManagedIdentityIdType.RESOURCE_ID) {
            LOG.info("[Managed Identity] Adding user assigned resource id to the request for Service Fabric Managed Identity.");
            this.managedIdentityRequest.queryParameters.put("mi_res_id", Collections.singletonList(this.userAssignedId));
        }
    }

    private ServiceFabricManagedIdentitySource(MsalRequest msalRequest, ServiceBundle serviceBundle, URI uRI, String string) {
        super(msalRequest, serviceBundle, ManagedIdentitySourceType.SERVICE_FABRIC);
        this.msiEndpoint = uRI;
        this.identityHeader = string;
        this.idType = ((ManagedIdentityApplication)msalRequest.application()).getManagedIdentityId().getIdType();
        this.userAssignedId = ((ManagedIdentityApplication)msalRequest.application()).getManagedIdentityId().getUserAssignedId();
    }

    @Override
    public ManagedIdentityResponse getManagedIdentityResponse(ManagedIdentityParameters managedIdentityParameters) {
        IHttpResponse iHttpResponse;
        this.createManagedIdentityRequest(managedIdentityParameters.resource);
        try {
            HttpRequest httpRequest = this.managedIdentityRequest.method.equals((Object)HttpMethod.GET) ? new HttpRequest(HttpMethod.GET, this.managedIdentityRequest.computeURI().toString(), this.managedIdentityRequest.headers) : new HttpRequest(HttpMethod.POST, this.managedIdentityRequest.computeURI().toString(), this.managedIdentityRequest.headers, this.managedIdentityRequest.getBodyAsString());
            iHttpResponse = this.httpHelper.executeHttpRequest(httpRequest, this.managedIdentityRequest.requestContext(), this.serviceBundle.getTelemetryManager(), this.httpClient);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException(uRISyntaxException);
        }
        catch (MsalClientException msalClientException) {
            if (msalClientException.getCause() instanceof SocketException) {
                throw new MsalServiceException(msalClientException.getMessage(), "managed_identity_unreachable_network", this.managedIdentitySourceType);
            }
            throw msalClientException;
        }
        return this.handleResponse(managedIdentityParameters, iHttpResponse);
    }

    static AbstractManagedIdentitySource create(MsalRequest msalRequest, ServiceBundle serviceBundle) {
        IEnvironmentVariables iEnvironmentVariables = ServiceFabricManagedIdentitySource.getEnvironmentVariables();
        String string = iEnvironmentVariables.getEnvironmentVariable("IDENTITY_ENDPOINT");
        String string2 = iEnvironmentVariables.getEnvironmentVariable("IDENTITY_HEADER");
        String string3 = iEnvironmentVariables.getEnvironmentVariable("IDENTITY_SERVER_THUMBPRINT");
        if (StringHelper.isNullOrBlank(string) || StringHelper.isNullOrBlank(string2) || StringHelper.isNullOrBlank(string3)) {
            LOG.info("[Managed Identity] Service fabric managed identity is unavailable.");
            return null;
        }
        return new ServiceFabricManagedIdentitySource(msalRequest, serviceBundle, ServiceFabricManagedIdentitySource.validateAndGetUri(string), string2);
    }

    private static URI validateAndGetUri(String string) {
        try {
            URI uRI = new URI(string);
            LOG.info(String.format("[Managed Identity] Environment variables validation passed for Service Fabric Managed Identity. Endpoint URI: %s", uRI));
            return uRI;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new MsalServiceException(String.format("[Managed Identity] The environment variable %s contains an invalid Uri %s in %s managed identity source.", "MSI_ENDPOINT", string, "Service Fabric"), "invalid_managed_identity_endpoint", ManagedIdentitySourceType.SERVICE_FABRIC);
        }
    }
}

