/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.TreeSet;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractApplicationBase;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractMsalAuthorizationGrant;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.OAuthAuthorizationGrant;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RefreshTokenParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RequestContext;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SilentRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.AuthorizationGrant;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.RefreshTokenGrant;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.token.RefreshToken;

class RefreshTokenRequest
extends MsalRequest {
    private SilentRequest parentSilentRequest;
    private RefreshTokenParameters parameters;

    RefreshTokenRequest(RefreshTokenParameters refreshTokenParameters, AbstractApplicationBase abstractApplicationBase, RequestContext requestContext) {
        super(abstractApplicationBase, RefreshTokenRequest.createAuthenticationGrant(refreshTokenParameters), requestContext);
        this.parameters = refreshTokenParameters;
    }

    RefreshTokenRequest(RefreshTokenParameters refreshTokenParameters, AbstractApplicationBase abstractApplicationBase, RequestContext requestContext, SilentRequest silentRequest) {
        this(refreshTokenParameters, abstractApplicationBase, requestContext);
        this.parentSilentRequest = silentRequest;
    }

    private static AbstractMsalAuthorizationGrant createAuthenticationGrant(RefreshTokenParameters refreshTokenParameters) {
        RefreshTokenGrant refreshTokenGrant = new RefreshTokenGrant(new RefreshToken(refreshTokenParameters.refreshToken()));
        return new OAuthAuthorizationGrant((AuthorizationGrant)refreshTokenGrant, refreshTokenParameters.scopes(), refreshTokenParameters.claims());
    }

    String getFullThumbprint() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.application().clientId() + ".");
        String string = this.parentSilentRequest != null && this.parentSilentRequest.requestAuthority() != null ? this.parentSilentRequest.requestAuthority().authority() : this.application().authority();
        stringBuilder.append(string + ".");
        if (this.parentSilentRequest != null && this.parentSilentRequest.parameters().account() != null) {
            stringBuilder.append(this.parentSilentRequest.parameters().account().homeAccountId() + ".");
        }
        stringBuilder.append(this.parameters.refreshToken() + ".");
        TreeSet<String> treeSet = new TreeSet<String>(this.parameters.scopes());
        stringBuilder.append(String.join((CharSequence)" ", treeSet) + ".");
        return StringHelper.createSha256Hash(stringBuilder.toString());
    }
}

