/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClaimsRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAcquireTokenParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IUserAssertion;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ParameterValidationUtils;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.UserAssertion;

public class OnBehalfOfParameters
implements IAcquireTokenParameters {
    @NonNull
    private Set<String> scopes;
    private Boolean skipCache;
    @NonNull
    private IUserAssertion userAssertion;
    private ClaimsRequest claims;
    private Map<String, String> extraHttpHeaders;
    private Map<String, String> extraQueryParameters;
    private String tenant;

    private static OnBehalfOfParametersBuilder builder() {
        return new OnBehalfOfParametersBuilder();
    }

    public static OnBehalfOfParametersBuilder builder(Set<String> set, UserAssertion userAssertion) {
        ParameterValidationUtils.validateNotNull("scopes", set);
        return OnBehalfOfParameters.builder().scopes(set).userAssertion(userAssertion);
    }

    private static Boolean $default$skipCache() {
        return false;
    }

    @Override
    @NonNull
    public Set<String> scopes() {
        return this.scopes;
    }

    public Boolean skipCache() {
        return this.skipCache;
    }

    @NonNull
    public IUserAssertion userAssertion() {
        return this.userAssertion;
    }

    @Override
    public ClaimsRequest claims() {
        return this.claims;
    }

    @Override
    public Map<String, String> extraHttpHeaders() {
        return this.extraHttpHeaders;
    }

    @Override
    public Map<String, String> extraQueryParameters() {
        return this.extraQueryParameters;
    }

    @Override
    public String tenant() {
        return this.tenant;
    }

    private OnBehalfOfParameters(@NonNull Set<String> set, Boolean bl2, @NonNull IUserAssertion iUserAssertion, ClaimsRequest claimsRequest, Map<String, String> map, Map<String, String> map2, String string) {
        if (set == null) {
            throw new NullPointerException("scopes is marked @NonNull but is null");
        }
        if (iUserAssertion == null) {
            throw new NullPointerException("userAssertion is marked @NonNull but is null");
        }
        this.scopes = set;
        this.skipCache = bl2;
        this.userAssertion = iUserAssertion;
        this.claims = claimsRequest;
        this.extraHttpHeaders = map;
        this.extraQueryParameters = map2;
        this.tenant = string;
    }

    public static class OnBehalfOfParametersBuilder {
        private Set<String> scopes;
        private boolean skipCache$set;
        private Boolean skipCache;
        private IUserAssertion userAssertion;
        private ClaimsRequest claims;
        private Map<String, String> extraHttpHeaders;
        private Map<String, String> extraQueryParameters;
        private String tenant;

        OnBehalfOfParametersBuilder() {
        }

        public OnBehalfOfParametersBuilder scopes(Set<String> set) {
            this.scopes = set;
            return this;
        }

        public OnBehalfOfParametersBuilder skipCache(Boolean bl2) {
            this.skipCache = bl2;
            this.skipCache$set = true;
            return this;
        }

        public OnBehalfOfParametersBuilder userAssertion(IUserAssertion iUserAssertion) {
            this.userAssertion = iUserAssertion;
            return this;
        }

        public OnBehalfOfParametersBuilder claims(ClaimsRequest claimsRequest) {
            this.claims = claimsRequest;
            return this;
        }

        public OnBehalfOfParametersBuilder extraHttpHeaders(Map<String, String> map) {
            this.extraHttpHeaders = map;
            return this;
        }

        public OnBehalfOfParametersBuilder extraQueryParameters(Map<String, String> map) {
            this.extraQueryParameters = map;
            return this;
        }

        public OnBehalfOfParametersBuilder tenant(String string) {
            this.tenant = string;
            return this;
        }

        public OnBehalfOfParameters build() {
            Boolean bl2 = this.skipCache;
            if (!this.skipCache$set) {
                bl2 = OnBehalfOfParameters.$default$skipCache();
            }
            return new OnBehalfOfParameters(this.scopes, bl2, this.userAssertion, this.claims, this.extraHttpHeaders, this.extraQueryParameters, this.tenant);
        }

        public String toString() {
            return "OnBehalfOfParameters.OnBehalfOfParametersBuilder(scopes=" + this.scopes + ", skipCache=" + this.skipCache + ", userAssertion=" + this.userAssertion + ", claims=" + this.claims + ", extraHttpHeaders=" + this.extraHttpHeaders + ", extraQueryParameters=" + this.extraQueryParameters + ", tenant=" + this.tenant + ")";
        }
    }
}

