/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.Arrays;
import java.util.HashSet;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ErrorResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IHttpResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.JsonHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalInteractionRequiredException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalServiceException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPResponse;

class MsalServiceExceptionFactory {
    private MsalServiceExceptionFactory() {
    }

    static MsalServiceException fromHttpResponse(HTTPResponse hTTPResponse) {
        String string = hTTPResponse.getContent();
        if (string == null || StringHelper.isBlank(string)) {
            return new MsalServiceException(String.format("Unknown Service Exception. Service returned status code %s", hTTPResponse.getStatusCode()), "unknown");
        }
        ErrorResponse errorResponse = JsonHelper.convertJsonToObject(string, ErrorResponse.class);
        errorResponse.statusCode(hTTPResponse.getStatusCode());
        errorResponse.statusMessage(hTTPResponse.getStatusMessage());
        if (errorResponse.error() != null && errorResponse.error().equalsIgnoreCase("invalid_grant") && MsalServiceExceptionFactory.isInteractionRequired(errorResponse.subError)) {
            return new MsalInteractionRequiredException(errorResponse, hTTPResponse.getHeaderMap());
        }
        return new MsalServiceException(errorResponse, hTTPResponse.getHeaderMap());
    }

    static MsalServiceException fromHttpResponse(IHttpResponse iHttpResponse) {
        String string = iHttpResponse.body();
        if (StringHelper.isBlank(string)) {
            return new MsalServiceException(String.format("Unknown service exception. Http request returned status code %s with no response body", iHttpResponse.statusCode()), "unknown");
        }
        ErrorResponse errorResponse = JsonHelper.convertJsonToObject(string, ErrorResponse.class);
        if (!StringHelper.isBlank(errorResponse.error()) && !StringHelper.isBlank(errorResponse.errorDescription)) {
            errorResponse.statusCode(iHttpResponse.statusCode());
            return new MsalServiceException(errorResponse, iHttpResponse.headers());
        }
        return new MsalServiceException(String.format("Unknown service exception. Http request returned status code: %s with http body: %s", iHttpResponse.statusCode(), string), "unknown");
    }

    private static boolean isInteractionRequired(String string) {
        String[] stringArray = new String[]{"client_mismatch", "protection_policy_required"};
        HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
        if (StringHelper.isBlank(string)) {
            return true;
        }
        return !hashSet.contains(string);
    }
}

