/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.DeviceCode;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.DeviceCodeAuthorizationGrant;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.DeviceCodeFlowParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpMethod;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HttpRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IAuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.IHttpResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.JsonHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalServiceExceptionFactory;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PublicClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RequestContext;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ServiceBundle;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;

class DeviceCodeFlowRequest
extends MsalRequest {
    private AtomicReference<CompletableFuture<IAuthenticationResult>> futureReference;
    private DeviceCodeFlowParameters parameters;
    private String scopesStr;

    DeviceCodeFlowRequest(DeviceCodeFlowParameters deviceCodeFlowParameters, AtomicReference<CompletableFuture<IAuthenticationResult>> atomicReference, PublicClientApplication publicClientApplication, RequestContext requestContext) {
        super(publicClientApplication, null, requestContext);
        this.parameters = deviceCodeFlowParameters;
        this.scopesStr = String.join((CharSequence)" ", deviceCodeFlowParameters.scopes());
        this.futureReference = atomicReference;
    }

    DeviceCode acquireDeviceCode(String string, String string2, Map<String, String> map, ServiceBundle serviceBundle) {
        Map<String, String> map2 = this.appendToHeaders(map);
        String string3 = this.createQueryParams(string2);
        HttpRequest httpRequest = new HttpRequest(HttpMethod.POST, string, map2, string3);
        IHttpResponse iHttpResponse = serviceBundle.getHttpHelper().executeHttpRequest(httpRequest, this.requestContext(), serviceBundle);
        if (iHttpResponse.statusCode() != 200) {
            throw MsalServiceExceptionFactory.fromHttpResponse(iHttpResponse);
        }
        return this.parseJsonToDeviceCodeAndSetParameters(iHttpResponse.body(), map2, string2);
    }

    void createAuthenticationGrant(DeviceCode deviceCode) {
        this.msalAuthorizationGrant = new DeviceCodeAuthorizationGrant(deviceCode, deviceCode.scopes(), this.parameters.claims());
    }

    private String createQueryParams(String string) {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        hashMap.put("client_id", Collections.singletonList(string));
        String string2 = "openid profile offline_access " + this.scopesStr;
        hashMap.put("scope", Collections.singletonList(string2));
        return URLUtils.serializeParameters(hashMap);
    }

    private Map<String, String> appendToHeaders(Map<String, String> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        hashMap.put("Accept", "application/json");
        return hashMap;
    }

    private DeviceCode parseJsonToDeviceCodeAndSetParameters(String string, Map<String, String> map, String string2) {
        DeviceCode deviceCode = JsonHelper.convertJsonToObject(string, DeviceCode.class);
        String string3 = map.get("client-request-id");
        if (string3 != null) {
            deviceCode.correlationId(string3);
        }
        deviceCode.clientId(string2);
        deviceCode.scopes(this.scopesStr);
        return deviceCode;
    }

    AtomicReference<CompletableFuture<IAuthenticationResult>> futureReference() {
        return this.futureReference;
    }

    DeviceCodeFlowParameters parameters() {
        return this.parameters;
    }

    String scopesStr() {
        return this.scopesStr;
    }
}

