/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.DefaultHttpClient;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;

class DefaultHttpClientManagedIdentity
extends DefaultHttpClient {
    public static final HostnameVerifier ALL_HOSTS_ACCEPT_HOSTNAME_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String string, SSLSession sSLSession) {
            return true;
        }
    };

    DefaultHttpClientManagedIdentity(Proxy proxy, SSLSocketFactory sSLSocketFactory, Integer n2, Integer n3) {
        super(proxy, sSLSocketFactory, n2, n3);
    }

    @Override
    HttpURLConnection openConnection(URL uRL) throws IOException {
        URLConnection uRLConnection = this.proxy != null ? uRL.openConnection(this.proxy) : uRL.openConnection();
        uRLConnection.setConnectTimeout(this.connectTimeout);
        uRLConnection.setReadTimeout(this.readTimeout);
        if (uRLConnection instanceof HttpURLConnection) {
            return (HttpURLConnection)uRLConnection;
        }
        HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRLConnection;
        if (this.sslSocketFactory != null) {
            httpsURLConnection.setSSLSocketFactory(this.sslSocketFactory);
        }
        if (System.getenv("IDENTITY_SERVER_THUMBPRINT") != null) {
            DefaultHttpClientManagedIdentity.addTrustedCertificateThumbprint(httpsURLConnection, System.getenv("IDENTITY_SERVER_THUMBPRINT"));
        }
        return httpsURLConnection;
    }

    public static void addTrustedCertificateThumbprint(HttpsURLConnection httpsURLConnection, final String string) {
        SSLSocketFactory sSLSocketFactory;
        if (httpsURLConnection.getHostnameVerifier() != ALL_HOSTS_ACCEPT_HOSTNAME_VERIFIER) {
            httpsURLConnection.setHostnameVerifier(ALL_HOSTS_ACCEPT_HOSTNAME_VERIFIER);
        }
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string2) throws CertificateException {
                throw new CertificateException("No client side certificate configured.");
            }

            @Override
            public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string3) throws CertificateException {
                if (x509CertificateArray == null || x509CertificateArray.length == 0) {
                    throw new CertificateException("Did not receive any certificate from the server.");
                }
                for (X509Certificate x509Certificate : x509CertificateArray) {
                    String string2 = DefaultHttpClientManagedIdentity.extractCertificateThumbprint(x509Certificate);
                    if (!string.equalsIgnoreCase(string2)) continue;
                    return;
                }
                throw new RuntimeException("Thumbprint of certificates received did not match the expected thumbprint.");
            }
        }};
        try {
            SSLContext sSLContext = SSLContext.getInstance("TLS");
            sSLContext.init(null, trustManagerArray, null);
            sSLSocketFactory = sSLContext.getSocketFactory();
        }
        catch (KeyManagementException | NoSuchAlgorithmException generalSecurityException) {
            throw new RuntimeException("Error Creating SSL Context", generalSecurityException);
        }
        if (httpsURLConnection.getSSLSocketFactory() != sSLSocketFactory) {
            httpsURLConnection.setSSLSocketFactory(sSLSocketFactory);
        }
    }

    private static String extractCertificateThumbprint(Certificate certificate) {
        try {
            byte[] byArray;
            byte[] byArray2;
            StringBuilder stringBuilder = new StringBuilder();
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            try {
                byArray2 = certificate.getEncoded();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new RuntimeException(certificateEncodingException);
            }
            for (byte by2 : byArray = messageDigest.digest(byArray2)) {
                int n2 = by2 & 0xFF;
                if (n2 < 16) {
                    stringBuilder.append("0");
                }
                stringBuilder.append(Integer.toHexString(n2));
            }
            return stringBuilder.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new MsalClientException("NoSuchAlgorithmException when extracting certificate thumbprint: ", noSuchAlgorithmException.getMessage());
        }
    }
}

