/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.Map;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.Event;

class DefaultEvent
extends Event {
    private static final String CLIENT_ID_KEY = "msal.client_id";
    private static final String SDK_PLATFORM_KEY = "msal.sdk_platform";
    private static final String SDK_VERSION_KEY = "msal.sdk_version";
    private static final String HTTP_EVENT_COUNT_KEY = "msal.http_event_count";
    private static final String CACHE_EVENT_COUNT_KEY = "msal.cache_event_count";
    private Map<String, Integer> eventCount;

    public DefaultEvent(String string, Map<String, Integer> map) {
        super("msal.default_event");
        this.setClientId(string);
        this.setSdkPlatform();
        this.setSdkVersion();
        this.eventCount = map;
        this.setHttpEventCount();
        this.setCacheEventCount();
    }

    private void setClientId(String string) {
        this.put(CLIENT_ID_KEY, string);
    }

    private void setSdkPlatform() {
        this.put(SDK_PLATFORM_KEY, System.getProperty("os.name"));
    }

    private void setSdkVersion() {
        this.put(SDK_VERSION_KEY, this.getClass().getPackage().getImplementationVersion());
    }

    private void setHttpEventCount() {
        this.put(HTTP_EVENT_COUNT_KEY, this.getEventCount("msal.http_event"));
    }

    private void setCacheEventCount() {
        this.put(CACHE_EVENT_COUNT_KEY, this.getEventCount("msal.cache_event"));
    }

    private String getEventCount(String string) {
        return this.eventCount.getOrDefault(string, 0).toString();
    }
}

