/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.HTTPContentType;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.SerializeException;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.http.HTTPRequest;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.id.ClientID;
import macromedia.jdbc.sqlserver.externals.com.nimbusds.oauth2.sdk.util.URLUtils;

class ClientAuthenticationPost
extends ClientAuthentication {
    protected ClientAuthenticationPost(ClientAuthenticationMethod clientAuthenticationMethod, ClientID clientID) {
        super(clientAuthenticationMethod, clientID);
    }

    @Override
    public Set<String> getFormParameterNames() {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("client_assertion", "client_assertion_type", "client_id")));
    }

    Map<String, List<String>> toParameters() {
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        hashMap.put("client_id", Collections.singletonList(this.getClientID().getValue()));
        return hashMap;
    }

    @Override
    public void applyTo(HTTPRequest hTTPRequest) throws SerializeException {
        if (hTTPRequest.getMethod() != HTTPRequest.Method.POST) {
            throw new SerializeException("The HTTP request method must be POST");
        }
        String string = String.valueOf(hTTPRequest.getEntityContentType());
        if (string == null) {
            throw new SerializeException("Missing HTTP Content-Type header");
        }
        if (!string.equals(HTTPContentType.ApplicationURLEncoded.contentType)) {
            throw new SerializeException("The HTTP Content-Type header must be " + HTTPContentType.ApplicationURLEncoded.contentType);
        }
        Map<String, List<String>> map = hTTPRequest.getQueryParameters();
        map.putAll(this.toParameters());
        String string2 = URLUtils.serializeParameters(map);
        hTTPRequest.setQuery(string2);
    }
}

