/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.type.TypeReference;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonNode;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ObjectMapper;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.ObjectReader;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.node.ObjectNode;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RequestedClaim;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RequestedClaimAdditionalInfo;

public class ClaimsRequest {
    List<RequestedClaim> idTokenRequestedClaims = new ArrayList<RequestedClaim>();
    List<RequestedClaim> userInfoRequestedClaims = new ArrayList<RequestedClaim>();
    List<RequestedClaim> accessTokenRequestedClaims = new ArrayList<RequestedClaim>();

    public void requestClaimInIdToken(String string, RequestedClaimAdditionalInfo requestedClaimAdditionalInfo) {
        this.idTokenRequestedClaims.add(new RequestedClaim(string, requestedClaimAdditionalInfo));
    }

    protected void requestClaimInUserInfo(String string, RequestedClaimAdditionalInfo requestedClaimAdditionalInfo) {
        this.userInfoRequestedClaims.add(new RequestedClaim(string, requestedClaimAdditionalInfo));
    }

    protected void requestClaimInAccessToken(String string, RequestedClaimAdditionalInfo requestedClaimAdditionalInfo) {
        this.accessTokenRequestedClaims.add(new RequestedClaim(string, requestedClaimAdditionalInfo));
    }

    public String formatAsJSONString() {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        if (!this.idTokenRequestedClaims.isEmpty()) {
            objectNode.set("id_token", this.convertClaimsToObjectNode(this.idTokenRequestedClaims));
        }
        if (!this.userInfoRequestedClaims.isEmpty()) {
            objectNode.set("userinfo", this.convertClaimsToObjectNode(this.userInfoRequestedClaims));
        }
        if (!this.accessTokenRequestedClaims.isEmpty()) {
            objectNode.set("access_token", this.convertClaimsToObjectNode(this.accessTokenRequestedClaims));
        }
        return ((JsonNode)objectMapper.valueToTree(objectNode)).toString();
    }

    private ObjectNode convertClaimsToObjectNode(List<RequestedClaim> list) {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode objectNode = objectMapper.createObjectNode();
        for (RequestedClaim requestedClaim : list) {
            objectNode.setAll((ObjectNode)objectMapper.valueToTree(requestedClaim));
        }
        return objectNode;
    }

    public static ClaimsRequest formatAsClaimsRequest(String string) {
        try {
            ClaimsRequest claimsRequest = new ClaimsRequest();
            ObjectMapper objectMapper = new ObjectMapper();
            ObjectReader objectReader = objectMapper.readerFor(new TypeReference<List<String>>(){});
            JsonNode jsonNode = objectMapper.readTree(string);
            ClaimsRequest.addClaimsFromJsonNode(jsonNode.get("id_token"), "id_token", claimsRequest, objectReader);
            ClaimsRequest.addClaimsFromJsonNode(jsonNode.get("userinfo"), "userinfo", claimsRequest, objectReader);
            ClaimsRequest.addClaimsFromJsonNode(jsonNode.get("access_token"), "access_token", claimsRequest, objectReader);
            return claimsRequest;
        }
        catch (IOException iOException) {
            throw new MsalClientException("Could not convert string to ClaimsRequest: " + iOException.getMessage(), "invalid_json");
        }
    }

    private static void addClaimsFromJsonNode(JsonNode jsonNode, String string, ClaimsRequest claimsRequest, ObjectReader objectReader) throws IOException {
        if (jsonNode != null) {
            Iterator<String> iterator = jsonNode.fieldNames();
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                Boolean bl2 = null;
                String string3 = null;
                List list = null;
                RequestedClaimAdditionalInfo requestedClaimAdditionalInfo = null;
                if (jsonNode.get(string2).has("essential")) {
                    bl2 = jsonNode.get(string2).get("essential").asBoolean();
                }
                if (jsonNode.get(string2).has("value")) {
                    string3 = jsonNode.get(string2).get("value").textValue();
                }
                if (jsonNode.get(string2).has("values")) {
                    list = (List)objectReader.readValue(jsonNode.get(string2).get("values"));
                }
                if (bl2 != null || string3 != null || list != null) {
                    requestedClaimAdditionalInfo = new RequestedClaimAdditionalInfo(bl2 == null ? false : bl2, string3, list);
                }
                if (string.equals("id_token")) {
                    claimsRequest.requestClaimInIdToken(string2, requestedClaimAdditionalInfo);
                }
                if (string.equals("userinfo")) {
                    claimsRequest.requestClaimInUserInfo(string2, requestedClaimAdditionalInfo);
                }
                if (!string.equals("access_token")) continue;
                claimsRequest.requestClaimInAccessToken(string2, requestedClaimAdditionalInfo);
            }
        }
    }

    public List<RequestedClaim> getIdTokenRequestedClaims() {
        return this.idTokenRequestedClaims;
    }

    public void setIdTokenRequestedClaims(List<RequestedClaim> list) {
        this.idTokenRequestedClaims = list;
    }
}

