/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.net.MalformedURLException;
import java.net.URL;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AADAuthority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ADFSAuthority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthorityType;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.B2CAuthority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.CIAMAuthority;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;

abstract class Authority {
    private static final String ADFS_PATH_SEGMENT = "adfs";
    private static final String B2C_PATH_SEGMENT = "tfp";
    private static final String B2C_HOST_SEGMENT = "b2clogin.com";
    private static final String USER_REALM_ENDPOINT = "common/userrealm";
    private static final String userRealmEndpointFormat = "https://%s/common/userrealm/%s?api-version=1.0";
    String authority;
    final URL canonicalAuthorityUrl;
    protected final AuthorityType authorityType;
    String selfSignedJwtAudience;
    String host;
    String tenant;
    boolean isTenantless;
    String authorizationEndpoint;
    String tokenEndpoint;
    String deviceCodeEndpoint;

    URL tokenEndpointUrl() throws MalformedURLException {
        return new URL(this.tokenEndpoint);
    }

    Authority(URL uRL, AuthorityType authorityType) {
        this.canonicalAuthorityUrl = uRL;
        this.authorityType = authorityType;
        this.setCommonAuthorityProperties();
    }

    private void setCommonAuthorityProperties() {
        this.tenant = Authority.getTenant(this.canonicalAuthorityUrl, this.authorityType);
        this.host = this.canonicalAuthorityUrl.getAuthority().toLowerCase();
    }

    static Authority createAuthority(URL uRL) throws MalformedURLException {
        Authority authority;
        AuthorityType authorityType = Authority.detectAuthorityType(uRL);
        if (authorityType == AuthorityType.AAD) {
            authority = new AADAuthority(uRL);
        } else if (authorityType == AuthorityType.B2C) {
            authority = new B2CAuthority(uRL);
        } else if (authorityType == AuthorityType.ADFS) {
            authority = new ADFSAuthority(uRL);
        } else if (authorityType == AuthorityType.CIAM) {
            authority = new CIAMAuthority(uRL);
        } else {
            throw new IllegalArgumentException("Unsupported Authority Type");
        }
        Authority.validateAuthority(authority.canonicalAuthorityUrl());
        return authority;
    }

    static AuthorityType detectAuthorityType(URL uRL) {
        String string;
        if (uRL == null) {
            throw new NullPointerException("canonicalAuthorityUrl");
        }
        String string2 = uRL.getPath().substring(1);
        if (StringHelper.isBlank(string2)) {
            if (Authority.isCiamAuthority(uRL.getHost())) {
                return AuthorityType.CIAM;
            }
            throw new IllegalArgumentException("authority Uri should have at least one segment in the path (i.e. https://<host>/<path>/...)");
        }
        String string3 = uRL.getHost();
        if (Authority.isB2CAuthority(string3, string = string2.substring(0, string2.indexOf("/")))) {
            return AuthorityType.B2C;
        }
        if (Authority.isAdfsAuthority(string)) {
            return AuthorityType.ADFS;
        }
        if (Authority.isCiamAuthority(string3)) {
            return AuthorityType.CIAM;
        }
        return AuthorityType.AAD;
    }

    static void validateAuthority(URL uRL) {
        if (!uRL.getProtocol().equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("authority should use the 'https' scheme");
        }
        if (uRL.toString().contains("#")) {
            throw new IllegalArgumentException("authority is invalid format (contains fragment)");
        }
        if (!StringHelper.isBlank(uRL.getQuery())) {
            throw new IllegalArgumentException("authority cannot contain query parameters");
        }
        String string = uRL.getPath();
        if (string.length() == 0) {
            throw new IllegalArgumentException("Authority Uri should have at least one segment in the path");
        }
        String[] stringArray = string.substring(1).split("/");
        if (stringArray.length == 0) {
            throw new IllegalArgumentException("Authority Uri must have at least one path segment. This is usually 'common' or the application's tenant id.");
        }
        for (String string2 : stringArray) {
            if (!StringHelper.isBlank(string2)) continue;
            throw new IllegalArgumentException("Authority Uri should not have empty path segments");
        }
    }

    static String getTenant(URL uRL, AuthorityType authorityType) {
        String[] stringArray = uRL.getPath().substring(1).split("/");
        if (authorityType == AuthorityType.B2C) {
            if (stringArray.length < 3) {
                return stringArray[0];
            }
            return stringArray[1];
        }
        return stringArray[0];
    }

    String getUserRealmEndpoint(String string) {
        return String.format(userRealmEndpointFormat, this.host, string);
    }

    private static boolean isAdfsAuthority(String string) {
        return string.compareToIgnoreCase(ADFS_PATH_SEGMENT) == 0;
    }

    private static boolean isB2CAuthority(String string, String string2) {
        return string.contains(B2C_HOST_SEGMENT) || string2.compareToIgnoreCase(B2C_PATH_SEGMENT) == 0;
    }

    private static boolean isCiamAuthority(String string) {
        return string.endsWith(".ciamlogin.com");
    }

    String deviceCodeEndpoint() {
        return this.deviceCodeEndpoint;
    }

    protected static String enforceTrailingSlash(String string) {
        if (!(string = string.toLowerCase()).endsWith("/")) {
            string = string + "/";
        }
        return string;
    }

    String authority() {
        return this.authority;
    }

    URL canonicalAuthorityUrl() {
        return this.canonicalAuthorityUrl;
    }

    AuthorityType authorityType() {
        return this.authorityType;
    }

    String selfSignedJwtAudience() {
        return this.selfSignedJwtAudience;
    }

    String host() {
        return this.host;
    }

    String tenant() {
        return this.tenant;
    }

    boolean isTenantless() {
        return this.isTenantless;
    }

    String authorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    String tokenEndpoint() {
        return this.tokenEndpoint;
    }
}

