/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import java.util.HashSet;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AcquireTokenSilentSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResultSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentityApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentityClient;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentityParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ManagedIdentityResponse;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PublicApi;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RequestContext;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SilentParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SilentRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.StringHelper;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.TokenRequestExecutor;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Logger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.LoggerFactory;

class AcquireTokenByManagedIdentitySupplier
extends AuthenticationResultSupplier {
    private static final Logger LOG = LoggerFactory.getLogger(AcquireTokenByManagedIdentitySupplier.class);
    private ManagedIdentityParameters managedIdentityParameters;

    AcquireTokenByManagedIdentitySupplier(ManagedIdentityApplication managedIdentityApplication, MsalRequest msalRequest) {
        super(managedIdentityApplication, msalRequest);
        this.managedIdentityParameters = (ManagedIdentityParameters)msalRequest.requestContext().apiParameters();
    }

    @Override
    AuthenticationResult execute() throws Exception {
        if (StringHelper.isNullOrBlank(this.managedIdentityParameters.resource)) {
            throw new MsalClientException("resource_required_managed_identity", "At least one scope needs to be requested for this authentication flow. ");
        }
        TokenRequestExecutor tokenRequestExecutor = new TokenRequestExecutor(this.clientApplication.authenticationAuthority, this.msalRequest, this.clientApplication.serviceBundle());
        if (!this.managedIdentityParameters.forceRefresh) {
            LOG.debug("ForceRefresh set to false. Attempting cache lookup");
            try {
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add(this.managedIdentityParameters.resource);
                SilentParameters silentParameters = SilentParameters.builder(hashSet).tenant(this.managedIdentityParameters.tenant()).build();
                RequestContext requestContext = new RequestContext(this.clientApplication, PublicApi.ACQUIRE_TOKEN_SILENTLY, silentParameters);
                SilentRequest silentRequest = new SilentRequest(silentParameters, this.clientApplication, requestContext, null);
                AcquireTokenSilentSupplier acquireTokenSilentSupplier = new AcquireTokenSilentSupplier(this.clientApplication, silentRequest);
                return acquireTokenSilentSupplier.execute();
            }
            catch (MsalClientException msalClientException) {
                if (msalClientException.errorCode().equals("cache_miss")) {
                    LOG.debug(String.format("Cache lookup failed: %s", msalClientException.getMessage()));
                    return this.fetchNewAccessTokenAndSaveToCache(tokenRequestExecutor);
                }
                LOG.error(String.format("Error occurred while cache lookup: %s", msalClientException.getMessage()));
                throw msalClientException;
            }
        }
        LOG.info("Skipped looking for an Access Token in the cache because forceRefresh or Claims were set. ");
        return this.fetchNewAccessTokenAndSaveToCache(tokenRequestExecutor);
    }

    private AuthenticationResult fetchNewAccessTokenAndSaveToCache(TokenRequestExecutor tokenRequestExecutor) {
        ManagedIdentityClient managedIdentityClient = new ManagedIdentityClient(this.msalRequest, tokenRequestExecutor.getServiceBundle());
        LOG.debug(String.format("[Managed Identity] Managed Identity source and ID type identified and set successfully, request will use Managed Identity for %s", managedIdentityClient.managedIdentitySource.managedIdentitySourceType.name()));
        ManagedIdentityResponse managedIdentityResponse = managedIdentityClient.getManagedIdentityResponse(this.managedIdentityParameters);
        AuthenticationResult authenticationResult = this.createFromManagedIdentityResponse(managedIdentityResponse);
        this.clientApplication.tokenCache.saveTokens(tokenRequestExecutor, authenticationResult, this.clientApplication.authenticationAuthority.host);
        return authenticationResult;
    }

    private AuthenticationResult createFromManagedIdentityResponse(ManagedIdentityResponse managedIdentityResponse) {
        long l2 = Long.valueOf(managedIdentityResponse.expiresOn);
        long l3 = l2 > 7200L ? l2 / 2L : 0L;
        return AuthenticationResult.builder().accessToken(managedIdentityResponse.getAccessToken()).scopes(this.managedIdentityParameters.resource()).expiresOn(l2).extExpiresOn(0L).refreshOn(l3).build();
    }
}

