/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j;

import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AbstractClientApplicationBase;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AcquireTokenByAppProviderSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AcquireTokenByAuthorizationGrantSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AcquireTokenSilentSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AppTokenProviderParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResult;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.AuthenticationResultSupplier;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ClientCredentialRequest;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.ConfidentialClientApplication;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.MsalClientException;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.PublicApi;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.RequestContext;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SilentParameters;
import macromedia.jdbc.sqlserver.externals.com.microsoft.aad.msal4j.SilentRequest;
import macromedia.jdbc.sqlserver.externals.org.slf4j.Logger;
import macromedia.jdbc.sqlserver.externals.org.slf4j.LoggerFactory;

class AcquireTokenByClientCredentialSupplier
extends AuthenticationResultSupplier {
    private static final Logger LOG = LoggerFactory.getLogger(AcquireTokenByClientCredentialSupplier.class);
    private ClientCredentialRequest clientCredentialRequest;

    AcquireTokenByClientCredentialSupplier(ConfidentialClientApplication confidentialClientApplication, ClientCredentialRequest clientCredentialRequest) {
        super(confidentialClientApplication, clientCredentialRequest);
        this.clientCredentialRequest = clientCredentialRequest;
    }

    @Override
    AuthenticationResult execute() throws Exception {
        if (this.clientCredentialRequest.parameters.skipCache() != null && !this.clientCredentialRequest.parameters.skipCache().booleanValue()) {
            LOG.debug("SkipCache set to false. Attempting cache lookup");
            try {
                SilentParameters silentParameters = SilentParameters.builder(this.clientCredentialRequest.parameters.scopes()).claims(this.clientCredentialRequest.parameters.claims()).build();
                RequestContext requestContext = new RequestContext(this.clientApplication, PublicApi.ACQUIRE_TOKEN_SILENTLY, silentParameters);
                SilentRequest silentRequest = new SilentRequest(silentParameters, this.clientApplication, requestContext, null);
                AcquireTokenSilentSupplier acquireTokenSilentSupplier = new AcquireTokenSilentSupplier(this.clientApplication, silentRequest);
                return acquireTokenSilentSupplier.execute();
            }
            catch (MsalClientException msalClientException) {
                LOG.debug(String.format("Cache lookup failed: %s", msalClientException.getMessage()));
                return this.acquireTokenByClientCredential();
            }
        }
        LOG.debug("SkipCache set to true. Skipping cache lookup and attempting client credentials request");
        return this.acquireTokenByClientCredential();
    }

    private AuthenticationResult acquireTokenByClientCredential() throws Exception {
        if (this.clientCredentialRequest.appTokenProvider != null) {
            String string = "";
            if (null != this.clientCredentialRequest.parameters.claims()) {
                string = this.clientCredentialRequest.parameters.claims().toString();
            }
            AppTokenProviderParameters appTokenProviderParameters = new AppTokenProviderParameters(this.clientCredentialRequest.parameters.scopes(), this.clientCredentialRequest.requestContext().correlationId(), string, this.clientCredentialRequest.parameters.tenant());
            AcquireTokenByAppProviderSupplier acquireTokenByAppProviderSupplier = new AcquireTokenByAppProviderSupplier((AbstractClientApplicationBase)this.clientApplication, this.clientCredentialRequest, appTokenProviderParameters);
            return acquireTokenByAppProviderSupplier.execute();
        }
        AcquireTokenByAuthorizationGrantSupplier acquireTokenByAuthorizationGrantSupplier = new AcquireTokenByAuthorizationGrantSupplier(this.clientApplication, this.clientCredentialRequest, null);
        return acquireTokenByAuthorizationGrantSupplier.execute();
    }
}

