/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.util;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DurationUnitConverter {
    private static final Map<String, DurationSerialization> UNITS;
    final DurationSerialization serialization;

    DurationUnitConverter(DurationSerialization durationSerialization) {
        this.serialization = durationSerialization;
    }

    public Duration convert(long l2) {
        return this.serialization.deserializer.apply(l2);
    }

    public long convert(Duration duration) {
        return this.serialization.serializer.apply(duration);
    }

    public static String descForAllowed() {
        return "\"" + UNITS.keySet().stream().collect(Collectors.joining("\", \"")) + "\"";
    }

    public static DurationUnitConverter from(String string) {
        DurationSerialization durationSerialization = UNITS.get(string);
        return durationSerialization == null ? null : new DurationUnitConverter(durationSerialization);
    }

    static {
        LinkedHashMap<String, DurationSerialization> linkedHashMap = new LinkedHashMap<String, DurationSerialization>();
        linkedHashMap.put(ChronoUnit.NANOS.name(), new DurationSerialization(Duration::toNanos, DurationSerialization.deserializer(ChronoUnit.NANOS)));
        linkedHashMap.put(ChronoUnit.MICROS.name(), new DurationSerialization(duration -> duration.toNanos() / 1000L, DurationSerialization.deserializer(ChronoUnit.MICROS)));
        linkedHashMap.put(ChronoUnit.MILLIS.name(), new DurationSerialization(Duration::toMillis, DurationSerialization.deserializer(ChronoUnit.MILLIS)));
        linkedHashMap.put(ChronoUnit.SECONDS.name(), new DurationSerialization(Duration::getSeconds, DurationSerialization.deserializer(ChronoUnit.SECONDS)));
        linkedHashMap.put(ChronoUnit.MINUTES.name(), new DurationSerialization(Duration::toMinutes, DurationSerialization.deserializer(ChronoUnit.MINUTES)));
        linkedHashMap.put(ChronoUnit.HOURS.name(), new DurationSerialization(Duration::toHours, DurationSerialization.deserializer(ChronoUnit.HOURS)));
        linkedHashMap.put(ChronoUnit.HALF_DAYS.name(), new DurationSerialization(duration -> duration.toHours() / 12L, DurationSerialization.deserializer(ChronoUnit.HALF_DAYS)));
        linkedHashMap.put(ChronoUnit.DAYS.name(), new DurationSerialization(Duration::toDays, DurationSerialization.deserializer(ChronoUnit.DAYS)));
        UNITS = linkedHashMap;
    }

    protected static class DurationSerialization {
        final Function<Duration, Long> serializer;
        final Function<Long, Duration> deserializer;

        DurationSerialization(Function<Duration, Long> function, Function<Long, Duration> function2) {
            this.serializer = function;
            this.deserializer = function2;
        }

        static Function<Long, Duration> deserializer(TemporalUnit temporalUnit) {
            return l2 -> Duration.of(l2, temporalUnit);
        }
    }
}

