/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.ser;

import java.io.IOException;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.time.format.DateTimeFormatter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonFormat;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializationFeature;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializerProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.ser.InstantSerializerBase;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;

public class ZonedDateTimeSerializer
extends InstantSerializerBase<ZonedDateTime> {
    private static final long serialVersionUID = 1L;
    public static final ZonedDateTimeSerializer INSTANCE = new ZonedDateTimeSerializer();
    protected final Boolean _writeZoneId;

    protected ZonedDateTimeSerializer() {
        this(DateTimeFormatter.ISO_OFFSET_DATE_TIME);
    }

    public ZonedDateTimeSerializer(DateTimeFormatter dateTimeFormatter) {
        super(ZonedDateTime.class, (T zonedDateTime) -> zonedDateTime.toInstant().toEpochMilli(), ChronoZonedDateTime::toEpochSecond, ZonedDateTime::getNano, dateTimeFormatter);
        this._writeZoneId = null;
    }

    protected ZonedDateTimeSerializer(ZonedDateTimeSerializer zonedDateTimeSerializer, Boolean bl2, DateTimeFormatter dateTimeFormatter, Boolean bl3) {
        this(zonedDateTimeSerializer, bl2, zonedDateTimeSerializer._useNanoseconds, dateTimeFormatter, zonedDateTimeSerializer._shape, bl3);
    }

    @Deprecated
    protected ZonedDateTimeSerializer(ZonedDateTimeSerializer zonedDateTimeSerializer, Boolean bl2, Boolean bl3, DateTimeFormatter dateTimeFormatter, Boolean bl4) {
        this(zonedDateTimeSerializer, bl2, bl3, dateTimeFormatter, zonedDateTimeSerializer._shape, bl4);
    }

    protected ZonedDateTimeSerializer(ZonedDateTimeSerializer zonedDateTimeSerializer, Boolean bl2, Boolean bl3, DateTimeFormatter dateTimeFormatter, JsonFormat.Shape shape, Boolean bl4) {
        super(zonedDateTimeSerializer, bl2, bl3, dateTimeFormatter, shape);
        this._writeZoneId = bl4;
    }

    @Override
    protected JSR310FormattedSerializerBase<?> withFormat(Boolean bl2, DateTimeFormatter dateTimeFormatter, JsonFormat.Shape shape) {
        return new ZonedDateTimeSerializer(this, bl2, this._useNanoseconds, dateTimeFormatter, shape, this._writeZoneId);
    }

    @Override
    @Deprecated
    protected JSR310FormattedSerializerBase<?> withFeatures(Boolean bl2) {
        return new ZonedDateTimeSerializer(this, this._useTimestamp, this._formatter, bl2);
    }

    @Override
    protected JSR310FormattedSerializerBase<?> withFeatures(Boolean bl2, Boolean bl3) {
        return new ZonedDateTimeSerializer(this, this._useTimestamp, bl3, this._formatter, bl2);
    }

    @Override
    public void serialize(ZonedDateTime zonedDateTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (!this.useTimestamp(serializerProvider) && this.shouldWriteWithZoneId(serializerProvider)) {
            jsonGenerator.writeString(DateTimeFormatter.ISO_ZONED_DATE_TIME.format(zonedDateTime));
            return;
        }
        super.serialize(zonedDateTime, jsonGenerator, serializerProvider);
    }

    public boolean shouldWriteWithZoneId(SerializerProvider serializerProvider) {
        return this._writeZoneId != null ? this._writeZoneId.booleanValue() : serializerProvider.isEnabled(SerializationFeature.WRITE_DATES_WITH_ZONE_ID);
    }

    @Override
    protected JsonToken serializationShape(SerializerProvider serializerProvider) {
        if (!this.useTimestamp(serializerProvider) && this.shouldWriteWithZoneId(serializerProvider)) {
            return JsonToken.VALUE_STRING;
        }
        return super.serializationShape(serializerProvider);
    }
}

