/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.ser;

import java.io.IOException;
import java.time.Year;
import java.time.format.DateTimeFormatter;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonFormat;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonParser;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonMappingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializerProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;

public class YearSerializer
extends JSR310FormattedSerializerBase<Year> {
    private static final long serialVersionUID = 1L;
    public static final YearSerializer INSTANCE = new YearSerializer();

    protected YearSerializer() {
        this((DateTimeFormatter)null);
    }

    public YearSerializer(DateTimeFormatter dateTimeFormatter) {
        super(Year.class, dateTimeFormatter);
    }

    protected YearSerializer(YearSerializer yearSerializer, Boolean bl2, DateTimeFormatter dateTimeFormatter) {
        super(yearSerializer, bl2, dateTimeFormatter, null);
    }

    protected YearSerializer withFormat(Boolean bl2, DateTimeFormatter dateTimeFormatter, JsonFormat.Shape shape) {
        return new YearSerializer(this, bl2, dateTimeFormatter);
    }

    @Override
    public void serialize(Year year, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.useTimestamp(serializerProvider)) {
            jsonGenerator.writeNumber(year.getValue());
        } else {
            String string = this._formatter == null ? year.toString() : year.format(this._formatter);
            jsonGenerator.writeString(string);
        }
    }

    @Override
    protected void _acceptTimestampVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        JsonIntegerFormatVisitor jsonIntegerFormatVisitor = jsonFormatVisitorWrapper.expectIntegerFormat(javaType);
        if (jsonIntegerFormatVisitor != null) {
            jsonIntegerFormatVisitor.numberType(JsonParser.NumberType.LONG);
        }
    }

    @Override
    protected JsonToken serializationShape(SerializerProvider serializerProvider) {
        return this.useTimestamp(serializerProvider) ? JsonToken.VALUE_NUMBER_INT : JsonToken.VALUE_STRING;
    }
}

