/*
 * Decompiled with CFR 0.152.
 */
package macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.ser;

import java.io.IOException;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.annotation.JsonFormat;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonGenerator;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.JsonToken;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.core.type.WritableTypeId;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JavaType;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.JsonMappingException;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.SerializerProvider;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonStringFormatVisitor;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsonFormatVisitors.JsonValueFormat;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import macromedia.jdbc.sqlserver.externals.com.fasterxml.jackson.datatype.jsr310.ser.JSR310FormattedSerializerBase;

public class LocalTimeSerializer
extends JSR310FormattedSerializerBase<LocalTime> {
    private static final long serialVersionUID = 1L;
    public static final LocalTimeSerializer INSTANCE = new LocalTimeSerializer();

    protected LocalTimeSerializer() {
        this((DateTimeFormatter)null);
    }

    public LocalTimeSerializer(DateTimeFormatter dateTimeFormatter) {
        super(LocalTime.class, dateTimeFormatter);
    }

    protected LocalTimeSerializer(LocalTimeSerializer localTimeSerializer, Boolean bl2, DateTimeFormatter dateTimeFormatter) {
        this(localTimeSerializer, bl2, null, dateTimeFormatter);
    }

    protected LocalTimeSerializer(LocalTimeSerializer localTimeSerializer, Boolean bl2, Boolean bl3, DateTimeFormatter dateTimeFormatter) {
        super(localTimeSerializer, bl2, bl3, dateTimeFormatter, null);
    }

    @Override
    protected JSR310FormattedSerializerBase<LocalTime> withFormat(Boolean bl2, DateTimeFormatter dateTimeFormatter, JsonFormat.Shape shape) {
        return new LocalTimeSerializer(this, bl2, dateTimeFormatter);
    }

    protected DateTimeFormatter _defaultFormatter() {
        return DateTimeFormatter.ISO_LOCAL_TIME;
    }

    @Override
    public void serialize(LocalTime localTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (this.useTimestamp(serializerProvider)) {
            jsonGenerator.writeStartArray();
            this._serializeAsArrayContents(localTime, jsonGenerator, serializerProvider);
            jsonGenerator.writeEndArray();
        } else {
            DateTimeFormatter dateTimeFormatter = this._formatter;
            if (dateTimeFormatter == null) {
                dateTimeFormatter = this._defaultFormatter();
            }
            jsonGenerator.writeString(localTime.format(dateTimeFormatter));
        }
    }

    @Override
    public void serializeWithType(LocalTime localTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider, TypeSerializer typeSerializer) throws IOException {
        WritableTypeId writableTypeId = typeSerializer.writeTypePrefix(jsonGenerator, typeSerializer.typeId(localTime, this.serializationShape(serializerProvider)));
        if (writableTypeId != null && writableTypeId.valueShape == JsonToken.START_ARRAY) {
            this._serializeAsArrayContents(localTime, jsonGenerator, serializerProvider);
        } else {
            DateTimeFormatter dateTimeFormatter = this._formatter;
            if (dateTimeFormatter == null) {
                dateTimeFormatter = this._defaultFormatter();
            }
            jsonGenerator.writeString(localTime.format(dateTimeFormatter));
        }
        typeSerializer.writeTypeSuffix(jsonGenerator, writableTypeId);
    }

    private final void _serializeAsArrayContents(LocalTime localTime, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        jsonGenerator.writeNumber(localTime.getHour());
        jsonGenerator.writeNumber(localTime.getMinute());
        int n2 = localTime.getSecond();
        int n3 = localTime.getNano();
        if (n2 > 0 || n3 > 0) {
            jsonGenerator.writeNumber(n2);
            if (n3 > 0) {
                if (this.useNanoseconds(serializerProvider)) {
                    jsonGenerator.writeNumber(n3);
                } else {
                    jsonGenerator.writeNumber(localTime.get(ChronoField.MILLI_OF_SECOND));
                }
            }
        }
    }

    @Override
    protected JsonToken serializationShape(SerializerProvider serializerProvider) {
        return this.useTimestamp(serializerProvider) ? JsonToken.START_ARRAY : JsonToken.VALUE_STRING;
    }

    @Override
    protected JSR310FormattedSerializerBase<?> withFeatures(Boolean bl2, Boolean bl3) {
        return new LocalTimeSerializer(this, this._useTimestamp, bl3, this._formatter);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper jsonFormatVisitorWrapper, JavaType javaType) throws JsonMappingException {
        if (this.useTimestamp(jsonFormatVisitorWrapper.getProvider())) {
            this._acceptTimestampVisitor(jsonFormatVisitorWrapper, javaType);
        } else {
            JsonStringFormatVisitor jsonStringFormatVisitor = jsonFormatVisitorWrapper.expectStringFormat(javaType);
            if (jsonStringFormatVisitor != null) {
                jsonStringFormatVisitor.format(JsonValueFormat.TIME);
            }
        }
    }
}

